/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.DependencyInjector;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.SuccessFunction;
import io.opentelemetry.testing.internal.armeria.common.TlsSetters;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.BlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopGroups;
import io.opentelemetry.testing.internal.armeria.common.util.SystemInfo;
import io.opentelemetry.testing.internal.armeria.common.util.TlsEngineType;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.SelfSignedCertificate;
import io.opentelemetry.testing.internal.armeria.internal.server.RouteDecoratingService;
import io.opentelemetry.testing.internal.armeria.internal.server.RouteUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.io.ByteStreams;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.net.HostAndPort;
import io.opentelemetry.testing.internal.armeria.server.AbstractAnnotatedServiceConfigSetters;
import io.opentelemetry.testing.internal.armeria.server.DecoratingHttpServiceFunction;
import io.opentelemetry.testing.internal.armeria.server.FallbackService;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.HttpServiceWithRoutes;
import io.opentelemetry.testing.internal.armeria.server.MultipartRemovalStrategy;
import io.opentelemetry.testing.internal.armeria.server.RejectedRouteHandler;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.RouteBuilder;
import io.opentelemetry.testing.internal.armeria.server.Routers;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.ServerBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServerSslContextUtil;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfigBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfigSetters;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfigsBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceNaming;
import io.opentelemetry.testing.internal.armeria.server.ShutdownSupport;
import io.opentelemetry.testing.internal.armeria.server.UnloggedExceptionsReporter;
import io.opentelemetry.testing.internal.armeria.server.VirtualHost;
import io.opentelemetry.testing.internal.armeria.server.VirtualHostAnnotatedServiceBindingBuilder;
import io.opentelemetry.testing.internal.armeria.server.VirtualHostContextPathServicesBuilder;
import io.opentelemetry.testing.internal.armeria.server.VirtualHostDecoratingServiceBindingBuilder;
import io.opentelemetry.testing.internal.armeria.server.VirtualHostServiceBindingBuilder;
import io.opentelemetry.testing.internal.armeria.server.annotation.ExceptionHandlerFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.RequestConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.ResponseConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogWriter;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Headers;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContext;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContextBuilder;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualHostBuilder
implements TlsSetters,
ServiceConfigsBuilder<VirtualHostBuilder> {
    private final ServerBuilder serverBuilder;
    private final boolean defaultVirtualHost;
    private final boolean portBased;
    private final List<ServiceConfigSetters<?>> serviceConfigSetters = new ArrayList();
    private final List<ShutdownSupport> shutdownSupports = new ArrayList<ShutdownSupport>();
    private final HttpHeadersBuilder defaultHeaders = HttpHeaders.builder();
    @Nullable
    private String defaultHostname;
    @Nullable
    private String hostnamePattern;
    private int port = -1;
    private String baseContextPath = "/";
    @Nullable
    private Supplier<SslContextBuilder> sslContextBuilderSupplier;
    @Nullable
    private Boolean tlsSelfSigned;
    @Nullable
    private SelfSignedCertificate selfSignedCertificate;
    private final List<Consumer<? super SslContextBuilder>> tlsCustomizers = new ArrayList<Consumer<? super SslContextBuilder>>();
    @Nullable
    private Boolean tlsAllowUnsafeCiphers;
    @Nullable
    private TlsEngineType tlsEngineType;
    private final LinkedList<RouteDecoratingService> routeDecoratingServices = new LinkedList();
    @Nullable
    private Function<? super VirtualHost, ? extends Logger> accessLoggerMapper;
    @Nullable
    private RejectedRouteHandler rejectedRouteHandler;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    @Nullable
    private AccessLogWriter accessLogWriter;
    @Nullable
    private AnnotatedServiceExtensions annotatedServiceExtensions;
    @Nullable
    private BlockingTaskExecutor blockingTaskExecutor;
    @Nullable
    private SuccessFunction successFunction;
    @Nullable
    private Long requestAutoAbortDelayMillis;
    @Nullable
    private Path multipartUploadsLocation;
    @Nullable
    private MultipartRemovalStrategy multipartRemovalStrategy;
    @Nullable
    private EventLoopGroup serviceWorkerGroup;
    @Nullable
    private Function<? super RoutingContext, ? extends RequestId> requestIdGenerator;
    @Nullable
    private ServiceErrorHandler errorHandler;
    private final VirtualHostContextPathServicesBuilder servicesBuilder = new VirtualHostContextPathServicesBuilder(this, this, (Set<String>)ImmutableSet.of("/"));
    private Supplier<AutoCloseable> contextHook = RequestContextUtil.NOOP_CONTEXT_HOOK;

    VirtualHostBuilder(ServerBuilder serverBuilder, boolean defaultVirtualHost) {
        this.serverBuilder = Objects.requireNonNull(serverBuilder, "serverBuilder");
        this.defaultVirtualHost = defaultVirtualHost;
        this.portBased = false;
    }

    VirtualHostBuilder(ServerBuilder serverBuilder, int port) {
        this.serverBuilder = Objects.requireNonNull(serverBuilder, "serverBuilder");
        this.port = port;
        this.portBased = true;
        this.defaultVirtualHost = true;
    }

    public ServerBuilder and() {
        return this.serverBuilder;
    }

    public VirtualHostBuilder defaultHostname(String defaultHostname) {
        this.defaultHostname = VirtualHost.normalizeDefaultHostname(defaultHostname);
        return this;
    }

    public VirtualHostBuilder baseContextPath(String baseContextPath) {
        this.baseContextPath = RouteUtil.ensureAbsolutePath(baseContextPath, "baseContextPath");
        return this;
    }

    @Deprecated
    public VirtualHostBuilder hostnamePattern(String hostnamePattern) {
        if (this.defaultVirtualHost) {
            throw new UnsupportedOperationException("Cannot set hostnamePattern for the default virtual host builder");
        }
        Preconditions.checkArgument(!hostnamePattern.isEmpty(), "hostnamePattern is empty.");
        HostAndPort hostAndPort = HostAndPort.fromString(hostnamePattern);
        if (hostAndPort.hasPort()) {
            this.port = hostAndPort.getPort();
            Preconditions.checkArgument(this.port >= 1 && this.port <= 65535, "port: %s (expected: 1-65535)", this.port);
            hostnamePattern = hostAndPort.getHost();
        }
        VirtualHost.validateHostnamePattern(hostnamePattern);
        this.hostnamePattern = VirtualHost.normalizeHostnamePattern(hostnamePattern);
        return this;
    }

    VirtualHostBuilder hostnamePattern(String hostnamePattern, int port) {
        if (this.defaultVirtualHost) {
            throw new UnsupportedOperationException("Cannot set hostnamePattern for the default virtual host builder");
        }
        this.hostnamePattern = hostnamePattern;
        if (port >= 1 && port <= 65535) {
            this.port = port;
        }
        return this;
    }

    @Override
    public VirtualHostBuilder tls(File keyCertChainFile, File keyFile) {
        return (VirtualHostBuilder)TlsSetters.super.tls(keyCertChainFile, keyFile);
    }

    @Override
    public VirtualHostBuilder tls(File keyCertChainFile, File keyFile, @Nullable String keyPassword) {
        Objects.requireNonNull(keyCertChainFile, "keyCertChainFile");
        Objects.requireNonNull(keyFile, "keyFile");
        return this.tls(() -> SslContextBuilder.forServer(keyCertChainFile, keyFile, keyPassword));
    }

    @Override
    public VirtualHostBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return (VirtualHostBuilder)TlsSetters.super.tls(keyCertChainInputStream, keyInputStream);
    }

    @Override
    public VirtualHostBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream, @Nullable String keyPassword) {
        byte[] key;
        byte[] keyCertChain;
        Objects.requireNonNull(keyCertChainInputStream, "keyCertChainInputStream");
        Objects.requireNonNull(keyInputStream, "keyInputStream");
        try {
            keyCertChain = ByteStreams.toByteArray(keyCertChainInputStream);
            key = ByteStreams.toByteArray(keyInputStream);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.tls(() -> SslContextBuilder.forServer(new ByteArrayInputStream(keyCertChain), new ByteArrayInputStream(key), keyPassword));
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, X509Certificate ... keyCertChain) {
        return (VirtualHostBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return (VirtualHostBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, @Nullable String keyPassword, X509Certificate ... keyCertChain) {
        return (VirtualHostBuilder)TlsSetters.super.tls(key, keyPassword, keyCertChain);
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, @Nullable String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(keyCertChain, "keyCertChain");
        for (X509Certificate x509Certificate : keyCertChain) {
            Objects.requireNonNull(x509Certificate, "keyCertChain contains null.");
        }
        return this.tls(() -> SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    @Override
    public VirtualHostBuilder tls(KeyManagerFactory keyManagerFactory) {
        Objects.requireNonNull(keyManagerFactory, "keyManagerFactory");
        return this.tls(() -> SslContextBuilder.forServer(keyManagerFactory));
    }

    private VirtualHostBuilder tls(Supplier<SslContextBuilder> sslContextBuilderSupplier) {
        Objects.requireNonNull(sslContextBuilderSupplier, "sslContextBuilderSupplier");
        Preconditions.checkState(this.sslContextBuilderSupplier == null, "TLS has been configured already.");
        Preconditions.checkState(!this.portBased, "Cannot configure TLS to a port-based virtual host. Please configure to %s.tls()", ServerBuilder.class.getSimpleName());
        this.sslContextBuilderSupplier = sslContextBuilderSupplier;
        return this;
    }

    public VirtualHostBuilder tlsSelfSigned() {
        return this.tlsSelfSigned(true);
    }

    public VirtualHostBuilder tlsSelfSigned(boolean tlsSelfSigned) {
        Preconditions.checkState(!this.portBased, "Cannot configure self-signed to a port-based virtual host. Please configure to %s.tlsSelfSigned()", ServerBuilder.class.getSimpleName());
        this.tlsSelfSigned = tlsSelfSigned;
        return this;
    }

    @Override
    public VirtualHostBuilder tlsCustomizer(Consumer<? super SslContextBuilder> tlsCustomizer) {
        Objects.requireNonNull(tlsCustomizer, "tlsCustomizer");
        Preconditions.checkState(!this.portBased, "Cannot configure TLS to a port-based virtual host. Please configure to %s.tlsCustomizer()", ServerBuilder.class.getSimpleName());
        this.tlsCustomizers.add(tlsCustomizer);
        return this;
    }

    @Deprecated
    public VirtualHostBuilder tlsAllowUnsafeCiphers() {
        return this.tlsAllowUnsafeCiphers(true);
    }

    @Deprecated
    public VirtualHostBuilder tlsAllowUnsafeCiphers(boolean tlsAllowUnsafeCiphers) {
        this.tlsAllowUnsafeCiphers = tlsAllowUnsafeCiphers;
        return this;
    }

    @UnstableApi
    public VirtualHostBuilder tlsEngineType(TlsEngineType tlsEngineType) {
        Objects.requireNonNull(tlsEngineType, "tlsEngineType");
        this.tlsEngineType = tlsEngineType;
        return this;
    }

    @UnstableApi
    public VirtualHostContextPathServicesBuilder contextPath(String ... contextPaths) {
        return this.contextPath(ImmutableSet.copyOf(Objects.requireNonNull(contextPaths, "contextPaths")));
    }

    @UnstableApi
    public VirtualHostContextPathServicesBuilder contextPath(Iterable<String> contextPaths) {
        Objects.requireNonNull(contextPaths, "contextPaths");
        return new VirtualHostContextPathServicesBuilder(this, this, (Set<String>)ImmutableSet.copyOf(contextPaths));
    }

    public VirtualHostBuilder withRoute(Consumer<? super VirtualHostServiceBindingBuilder> customizer) {
        Objects.requireNonNull(customizer, "customizer");
        VirtualHostServiceBindingBuilder builder = new VirtualHostServiceBindingBuilder(this);
        customizer.accept(builder);
        return this;
    }

    public VirtualHostServiceBindingBuilder route() {
        return new VirtualHostServiceBindingBuilder(this);
    }

    public VirtualHostDecoratingServiceBindingBuilder routeDecorator() {
        return new VirtualHostDecoratingServiceBindingBuilder(this);
    }

    @Override
    public VirtualHostBuilder serviceUnder(String pathPrefix, HttpService service) {
        this.servicesBuilder.serviceUnder(pathPrefix, service);
        return this;
    }

    @Override
    public VirtualHostBuilder service(String pathPattern, HttpService service) {
        this.servicesBuilder.service(pathPattern, service);
        return this;
    }

    @Override
    public VirtualHostBuilder service(Route route, HttpService service) {
        this.servicesBuilder.service(route, service);
        return this;
    }

    @Override
    public VirtualHostBuilder service(HttpServiceWithRoutes serviceWithRoutes, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        this.servicesBuilder.service(serviceWithRoutes, (Iterable)decorators);
        return this;
    }

    @Override
    @SafeVarargs
    public final VirtualHostBuilder service(HttpServiceWithRoutes serviceWithRoutes, Function<? super HttpService, ? extends HttpService> ... decorators) {
        this.servicesBuilder.service(serviceWithRoutes, (Function[])decorators);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(Object service) {
        this.servicesBuilder.annotatedService(service);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(Object service, Object ... exceptionHandlersAndConverters) {
        this.servicesBuilder.annotatedService(service, exceptionHandlersAndConverters);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        this.servicesBuilder.annotatedService(service, (Function)decorator, exceptionHandlersAndConverters);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(String pathPrefix, Object service) {
        this.servicesBuilder.annotatedService(pathPrefix, service);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Object ... exceptionHandlersAndConverters) {
        this.servicesBuilder.annotatedService(pathPrefix, service, exceptionHandlersAndConverters);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Iterable<?> exceptionHandlersAndConverters) {
        this.servicesBuilder.annotatedService(pathPrefix, service, (Iterable)exceptionHandlersAndConverters);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        this.servicesBuilder.annotatedService(pathPrefix, service, (Function)decorator, exceptionHandlersAndConverters);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<?> exceptionHandlersAndConverters) {
        this.servicesBuilder.annotatedService(pathPrefix, service, (Function)decorator, (Iterable)exceptionHandlersAndConverters);
        return this;
    }

    @Override
    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions, Iterable<? extends RequestConverterFunction> requestConverterFunctions, Iterable<? extends ResponseConverterFunction> responseConverterFunctions) {
        this.servicesBuilder.annotatedService(pathPrefix, service, (Function)decorator, (Iterable)exceptionHandlerFunctions, (Iterable)requestConverterFunctions, (Iterable)responseConverterFunctions);
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder annotatedService() {
        return new VirtualHostAnnotatedServiceBindingBuilder(this);
    }

    VirtualHostBuilder addServiceConfigSetters(ServiceConfigSetters<?> serviceConfigSetters) {
        this.serviceConfigSetters.add(serviceConfigSetters);
        return this;
    }

    private List<ServiceConfigSetters<?>> getServiceConfigSetters(@Nullable VirtualHostBuilder defaultVirtualHostBuilder) {
        ImmutableCollection serviceConfigSetters = defaultVirtualHostBuilder != null ? ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.serviceConfigSetters)).addAll(defaultVirtualHostBuilder.serviceConfigSetters)).build() : ImmutableList.copyOf(this.serviceConfigSetters);
        return serviceConfigSetters;
    }

    VirtualHostBuilder addRouteDecoratingService(RouteDecoratingService routeDecoratingService) {
        if (Flags.useLegacyRouteDecoratorOrdering()) {
            this.routeDecoratingServices.addLast(routeDecoratingService);
        } else {
            this.routeDecoratingServices.addFirst(routeDecoratingService);
        }
        return this;
    }

    @Nullable
    private Function<? super HttpService, ? extends HttpService> getRouteDecoratingService(@Nullable VirtualHostBuilder defaultVirtualHostBuilder, String baseContextPath) {
        ImmutableCollection routeDecoratingServices = defaultVirtualHostBuilder != null ? ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.routeDecoratingServices)).addAll(defaultVirtualHostBuilder.routeDecoratingServices)).build() : ImmutableList.copyOf(this.routeDecoratingServices);
        if (!routeDecoratingServices.isEmpty()) {
            List prefixed = routeDecoratingServices.stream().map(service -> service.withRoutePrefix(baseContextPath)).collect(ImmutableList.toImmutableList());
            return RouteDecoratingService.newDecorator(Routers.ofRouteDecoratingService(prefixed), routeDecoratingServices);
        }
        return null;
    }

    @Override
    public VirtualHostBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        this.servicesBuilder.decorator((Function)decorator);
        return this;
    }

    @Override
    public VirtualHostBuilder decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        this.servicesBuilder.decorator(decoratingHttpServiceFunction);
        return this;
    }

    @Override
    public VirtualHostBuilder decorator(String pathPattern, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        this.servicesBuilder.decorator(pathPattern, decoratingHttpServiceFunction);
        return this;
    }

    @Override
    public VirtualHostBuilder decorator(String pathPattern, Function<? super HttpService, ? extends HttpService> decorator) {
        this.servicesBuilder.decorator(pathPattern, (Function)decorator);
        return this;
    }

    @Override
    public VirtualHostBuilder decorator(Route route, Function<? super HttpService, ? extends HttpService> decorator) {
        this.servicesBuilder.decorator(route, (Function)decorator);
        return this;
    }

    @Override
    public VirtualHostBuilder decorator(Route route, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        this.servicesBuilder.decorator(route, decoratingHttpServiceFunction);
        return this;
    }

    @Override
    public VirtualHostBuilder decoratorUnder(String prefix, Function<? super HttpService, ? extends HttpService> decorator) {
        this.servicesBuilder.decoratorUnder(prefix, (Function)decorator);
        return this;
    }

    @Override
    public VirtualHostBuilder decoratorUnder(String prefix, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        this.servicesBuilder.decoratorUnder(prefix, decoratingHttpServiceFunction);
        return this;
    }

    public VirtualHostBuilder accessLogger(Function<? super VirtualHost, ? extends Logger> mapper) {
        this.accessLoggerMapper = Objects.requireNonNull(mapper, "mapper");
        return this;
    }

    public VirtualHostBuilder accessLogger(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        return this.accessLogger((? super VirtualHost host) -> logger);
    }

    public VirtualHostBuilder accessLogger(String loggerName) {
        Objects.requireNonNull(loggerName, "loggerName");
        return this.accessLogger((? super VirtualHost host) -> LoggerFactory.getLogger((String)loggerName));
    }

    public VirtualHostBuilder errorHandler(ServiceErrorHandler errorHandler) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        this.errorHandler = this.errorHandler == null ? errorHandler : this.errorHandler.orElse(errorHandler);
        return this;
    }

    public VirtualHostBuilder rejectedRouteHandler(RejectedRouteHandler handler) {
        this.rejectedRouteHandler = Objects.requireNonNull(handler, "handler");
        return this;
    }

    @UnstableApi
    public VirtualHostBuilder addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.addObject(name, value);
        return this;
    }

    @UnstableApi
    public VirtualHostBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "headers");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.addObject(defaultHeaders);
        return this;
    }

    @UnstableApi
    public VirtualHostBuilder setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.setObject(name, value);
        return this;
    }

    @UnstableApi
    public VirtualHostBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "headers");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.setObject(defaultHeaders);
        return this;
    }

    static void ensureNoPseudoHeader(CharSequence name) {
        Preconditions.checkArgument(!Http2Headers.PseudoHeaderName.isPseudoHeader(name), "Can't set a pseudo-header: %s", (Object)name);
    }

    static void ensureNoPseudoHeader(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        for (Map.Entry<CharSequence, ?> header : headers) {
            VirtualHostBuilder.ensureNoPseudoHeader(header.getKey());
        }
    }

    public VirtualHostBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    public VirtualHostBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming);
        return this;
    }

    public VirtualHostBuilder defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    @Nullable
    String defaultLogName() {
        return this.defaultLogName;
    }

    public VirtualHostBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = ServiceConfig.validateRequestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    public VirtualHostBuilder maxRequestLength(long maxRequestLength) {
        this.maxRequestLength = ServiceConfig.validateMaxRequestLength(maxRequestLength);
        return this;
    }

    public VirtualHostBuilder verboseResponses(boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
        return this;
    }

    public VirtualHostBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.accessLogWriter = this.accessLogWriter != null ? this.accessLogWriter.andThen(accessLogWriter) : accessLogWriter;
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(accessLogWriter));
        }
        return this;
    }

    public VirtualHostBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        return this.blockingTaskExecutor(BlockingTaskExecutor.of(blockingTaskExecutor), shutdownOnStop);
    }

    public VirtualHostBuilder blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(blockingTaskExecutor));
        }
        return this;
    }

    public VirtualHostBuilder blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @UnstableApi
    public VirtualHostBuilder successFunction(SuccessFunction successFunction) {
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        return this;
    }

    @Nullable
    SuccessFunction successFunction() {
        return this.successFunction;
    }

    @UnstableApi
    public VirtualHostBuilder requestAutoAbortDelay(Duration delay) {
        return this.requestAutoAbortDelayMillis(Objects.requireNonNull(delay, "delay").toMillis());
    }

    @UnstableApi
    public VirtualHostBuilder requestAutoAbortDelayMillis(long delayMillis) {
        this.requestAutoAbortDelayMillis = delayMillis;
        return this;
    }

    public VirtualHostBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.multipartUploadsLocation = Objects.requireNonNull(multipartUploadsLocation, "multipartUploadsLocation");
        return this;
    }

    @Nullable
    Path multipartUploadsLocation() {
        return this.multipartUploadsLocation;
    }

    @UnstableApi
    public VirtualHostBuilder multipartRemovalStrategy(MultipartRemovalStrategy removalStrategy) {
        this.multipartRemovalStrategy = Objects.requireNonNull(removalStrategy, "removalStrategy");
        return this;
    }

    public VirtualHostBuilder requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.requestIdGenerator = Objects.requireNonNull(requestIdGenerator, "requestIdGenerator");
        return this;
    }

    @UnstableApi
    public VirtualHostBuilder serviceWorkerGroup(EventLoopGroup serviceWorkerGroup, boolean shutdownOnStop) {
        this.serviceWorkerGroup = Objects.requireNonNull(serviceWorkerGroup, "serviceWorkerGroup");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(serviceWorkerGroup));
        }
        return this;
    }

    @UnstableApi
    public VirtualHostBuilder serviceWorkerGroup(int numThreads) {
        EventLoopGroup workerGroup = EventLoopGroups.newEventLoopGroup(numThreads);
        return this.serviceWorkerGroup(workerGroup, true);
    }

    public VirtualHostBuilder annotatedServiceExtensions(Iterable<? extends RequestConverterFunction> requestConverterFunctions, Iterable<? extends ResponseConverterFunction> responseConverterFunctions, Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.annotatedServiceExtensions = new AnnotatedServiceExtensions(ImmutableList.copyOf(requestConverterFunctions), ImmutableList.copyOf(responseConverterFunctions), ImmutableList.copyOf(exceptionHandlerFunctions));
        return this;
    }

    @Nullable
    AnnotatedServiceExtensions annotatedServiceExtensions() {
        return this.annotatedServiceExtensions;
    }

    @UnstableApi
    public VirtualHostBuilder contextHook(Supplier<? extends AutoCloseable> contextHook) {
        Objects.requireNonNull(contextHook, "contextHook");
        this.contextHook = RequestContextUtil.mergeHooks(this.contextHook, contextHook);
        return this;
    }

    VirtualHost build(VirtualHostBuilder template, DependencyInjector dependencyInjector, @Nullable UnloggedExceptionsReporter unloggedExceptionsReporter, ServerErrorHandler serverErrorHandler) {
        TlsEngineType tlsEngineType;
        RejectedRouteHandler rejectedRouteHandler;
        Objects.requireNonNull(template, "template");
        if (this.defaultHostname == null) {
            this.defaultHostname = this.hostnamePattern != null ? (this.hostnamePattern.startsWith("*.") ? this.hostnamePattern.substring(2) : this.hostnamePattern) : SystemInfo.hostname();
        }
        if (this.hostnamePattern == null) {
            this.hostnamePattern = this.defaultVirtualHost ? "*" : "*." + this.defaultHostname;
        }
        VirtualHost.ensureHostnamePatternMatchesDefaultHostname(this.hostnamePattern, this.defaultHostname);
        ServiceNaming defaultServiceNaming = this.defaultServiceNaming != null ? this.defaultServiceNaming : template.defaultServiceNaming;
        String defaultLogName = this.defaultLogName != null ? this.defaultLogName : template.defaultLogName;
        long requestTimeoutMillis = this.requestTimeoutMillis != null ? this.requestTimeoutMillis : template.requestTimeoutMillis;
        long maxRequestLength = this.maxRequestLength != null ? this.maxRequestLength : template.maxRequestLength;
        boolean verboseResponses = this.verboseResponses != null ? this.verboseResponses : template.verboseResponses;
        long requestAutoAbortDelayMillis = this.requestAutoAbortDelayMillis != null ? this.requestAutoAbortDelayMillis : template.requestAutoAbortDelayMillis;
        RejectedRouteHandler rejectedRouteHandler2 = rejectedRouteHandler = this.rejectedRouteHandler != null ? this.rejectedRouteHandler : template.rejectedRouteHandler;
        AccessLogWriter accessLogWriter = this.accessLogWriter != null ? this.accessLogWriter : (template.accessLogWriter != null ? template.accessLogWriter : AccessLogWriter.disabled());
        Function<? super VirtualHost, ? extends Logger> accessLoggerMapper = this.accessLoggerMapper != null ? this.accessLoggerMapper : template.accessLoggerMapper;
        AnnotatedServiceExtensions extensions = this.annotatedServiceExtensions != null ? this.annotatedServiceExtensions : template.annotatedServiceExtensions;
        BlockingTaskExecutor blockingTaskExecutor = this.blockingTaskExecutor != null ? this.blockingTaskExecutor : template.blockingTaskExecutor;
        SuccessFunction successFunction = this.successFunction != null ? this.successFunction : template.successFunction;
        Path multipartUploadsLocation = this.multipartUploadsLocation != null ? this.multipartUploadsLocation : template.multipartUploadsLocation;
        MultipartRemovalStrategy multipartRemovalStrategy = this.multipartRemovalStrategy != null ? this.multipartRemovalStrategy : template.multipartRemovalStrategy;
        HttpHeaders defaultHeaders = VirtualHostBuilder.mergeDefaultHeaders(template.defaultHeaders, this.defaultHeaders.build());
        Function<? super RoutingContext, ? extends RequestId> requestIdGenerator = this.requestIdGenerator != null ? this.requestIdGenerator : template.requestIdGenerator;
        ServiceErrorHandler serviceErrorHandler = serverErrorHandler.asServiceErrorHandler();
        ServiceErrorHandler defaultErrorHandler = this.errorHandler != null ? this.errorHandler.orElse(serviceErrorHandler) : serviceErrorHandler;
        Supplier<AutoCloseable> contextHook = RequestContextUtil.mergeHooks(template.contextHook, this.contextHook);
        EventLoopGroup serviceWorkerGroup = this.serviceWorkerGroup != null ? this.serviceWorkerGroup : (template.serviceWorkerGroup != null ? template.serviceWorkerGroup : this.serverBuilder.workerGroup);
        assert (defaultServiceNaming != null);
        assert (rejectedRouteHandler != null);
        assert (accessLoggerMapper != null);
        assert (extensions != null);
        assert (blockingTaskExecutor != null);
        assert (successFunction != null);
        assert (multipartUploadsLocation != null);
        assert (multipartRemovalStrategy != null);
        assert (requestIdGenerator != null);
        List serviceConfigs = this.getServiceConfigSetters(template).stream().flatMap(cfgSetters -> {
            if (cfgSetters instanceof AbstractAnnotatedServiceConfigSetters) {
                return ((AbstractAnnotatedServiceConfigSetters)cfgSetters).buildServiceConfigBuilder(extensions, dependencyInjector).stream();
            }
            if (cfgSetters instanceof ServiceConfigBuilder) {
                return Stream.of((ServiceConfigBuilder)cfgSetters);
            }
            throw new Error("Unexpected service config setters type: " + cfgSetters.getClass().getSimpleName());
        }).map(cfgBuilder -> cfgBuilder.build(defaultServiceNaming, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, blockingTaskExecutor, successFunction, requestAutoAbortDelayMillis, multipartUploadsLocation, multipartRemovalStrategy, serviceWorkerGroup, defaultHeaders, requestIdGenerator, defaultErrorHandler, unloggedExceptionsReporter, this.baseContextPath, contextHook)).collect(ImmutableList.toImmutableList());
        ServiceConfig fallbackServiceConfig = new ServiceConfigBuilder(RouteBuilder.FALLBACK_ROUTE, "/", FallbackService.INSTANCE).build(defaultServiceNaming, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, blockingTaskExecutor, successFunction, requestAutoAbortDelayMillis, multipartUploadsLocation, multipartRemovalStrategy, serviceWorkerGroup, defaultHeaders, requestIdGenerator, defaultErrorHandler, unloggedExceptionsReporter, "/", contextHook);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.shutdownSupports);
        builder.addAll(template.shutdownSupports);
        TlsEngineType tlsEngineType2 = tlsEngineType = this.tlsEngineType != null ? this.tlsEngineType : template.tlsEngineType;
        assert (tlsEngineType != null);
        VirtualHost virtualHost = new VirtualHost(this.defaultHostname, this.hostnamePattern, this.port, this.sslContext(template, tlsEngineType), tlsEngineType, serviceConfigs, fallbackServiceConfig, rejectedRouteHandler, accessLoggerMapper, defaultServiceNaming, defaultLogName, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, blockingTaskExecutor, requestAutoAbortDelayMillis, successFunction, multipartUploadsLocation, multipartRemovalStrategy, serviceWorkerGroup, (List<ShutdownSupport>)((Object)builder.build()), requestIdGenerator);
        Function<? super HttpService, ? extends HttpService> decorator = this.getRouteDecoratingService(template, this.baseContextPath);
        return decorator != null ? virtualHost.decorate(decorator) : virtualHost;
    }

    static HttpHeaders mergeDefaultHeaders(HttpHeadersBuilder lowPriorityHeaders, HttpHeaders highPriorityHeaders) {
        if (lowPriorityHeaders.isEmpty()) {
            return highPriorityHeaders;
        }
        if (highPriorityHeaders.isEmpty()) {
            return lowPriorityHeaders.build();
        }
        HttpHeadersBuilder headersBuilder = highPriorityHeaders.toBuilder();
        for (AsciiString name : lowPriorityHeaders.names()) {
            if (headersBuilder.contains(name)) continue;
            headersBuilder.add((CharSequence)name, lowPriorityHeaders.getAll(name));
        }
        return headersBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private SslContext sslContext(VirtualHostBuilder template, TlsEngineType tlsEngineType) {
        if (this.portBased) {
            return null;
        }
        SslContext sslContext = null;
        boolean releaseSslContextOnFailure = false;
        try {
            boolean tlsAllowUnsafeCiphers = this.tlsAllowUnsafeCiphers != null ? this.tlsAllowUnsafeCiphers : template.tlsAllowUnsafeCiphers;
            boolean sslContextFromThis = false;
            if (this.sslContextBuilderSupplier != null) {
                sslContext = ServerSslContextUtil.buildSslContext(this.sslContextBuilderSupplier, tlsEngineType, tlsAllowUnsafeCiphers, this.tlsCustomizers);
                sslContextFromThis = true;
                releaseSslContextOnFailure = true;
            } else if (template.sslContextBuilderSupplier != null) {
                sslContext = ServerSslContextUtil.buildSslContext(template.sslContextBuilderSupplier, tlsEngineType, tlsAllowUnsafeCiphers, template.tlsCustomizers);
                releaseSslContextOnFailure = true;
            }
            if (sslContext == null) {
                List<Consumer<? super SslContextBuilder>> tlsCustomizers;
                boolean tlsSelfSigned;
                if (this.tlsSelfSigned != null) {
                    tlsSelfSigned = this.tlsSelfSigned;
                    tlsCustomizers = this.tlsCustomizers;
                    sslContextFromThis = true;
                } else {
                    tlsSelfSigned = template.tlsSelfSigned;
                    tlsCustomizers = template.tlsCustomizers;
                }
                if (tlsSelfSigned) {
                    SelfSignedCertificate ssc;
                    try {
                        ssc = this.selfSignedCertificate();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("failed to create a self signed certificate", e);
                    }
                    sslContext = ServerSslContextUtil.buildSslContext(() -> SslContextBuilder.forServer(ssc.certificate(), ssc.privateKey()), tlsEngineType, tlsAllowUnsafeCiphers, tlsCustomizers);
                    releaseSslContextOnFailure = true;
                }
            }
            Preconditions.checkState(sslContextFromThis || this.tlsCustomizers.isEmpty(), "Cannot call tlsCustomizer() without tls() or tlsSelfSigned()");
            if (sslContext != null) {
                ServerSslContextUtil.validateSslContext(sslContext, tlsEngineType);
                Preconditions.checkState(sslContext.isServer(), "sslContextBuilder built a client SSL context.");
            }
            if (!(releaseSslContextOnFailure = false)) return sslContext;
        }
        catch (Throwable throwable) {
            if (!releaseSslContextOnFailure) throw throwable;
            ReferenceCountUtil.release(sslContext);
            throw throwable;
        }
        ReferenceCountUtil.release(sslContext);
        return sslContext;
    }

    private SelfSignedCertificate selfSignedCertificate() throws CertificateException {
        if (this.selfSignedCertificate == null) {
            this.selfSignedCertificate = new SelfSignedCertificate(this.defaultHostname);
            return this.selfSignedCertificate;
        }
        return this.selfSignedCertificate;
    }

    boolean equalsHostnamePattern(String validHostnamePattern, int port) {
        Preconditions.checkArgument(!validHostnamePattern.isEmpty(), "hostnamePattern is empty.");
        if (this.port != port) {
            return false;
        }
        return validHostnamePattern.equals(this.hostnamePattern);
    }

    int port() {
        return this.port;
    }

    boolean defaultVirtualHost() {
        return this.defaultVirtualHost;
    }
}

