/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.sse.ServerSentEvent;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.ClassUtil;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.annotation.ResponseConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.streaming.ServerSentEvents;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class ServerSentEventResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType contentType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (contentType != null && contentType.is(MediaType.EVENT_STREAM)) {
            return Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz);
        }
        if (ServerSentEvent.class.isAssignableFrom(clazz)) {
            return false;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        MediaType contentType = headers.contentType();
        if (contentType != null && contentType.is(MediaType.EVENT_STREAM)) {
            if (result instanceof Publisher) {
                return ServerSentEvents.fromPublisher(headers, (Publisher)result, trailers, ServerSentEventResponseConverterFunction::toSse);
            }
            if (result instanceof Stream) {
                return ServerSentEvents.fromStream(headers, (Stream)result, trailers, ctx.blockingTaskExecutor(), ServerSentEventResponseConverterFunction::toSse);
            }
            return ServerSentEvents.fromEvent(headers, ServerSentEventResponseConverterFunction.toSse(result), trailers);
        }
        if (result instanceof ServerSentEvent) {
            return ServerSentEvents.fromEvent(headers, (ServerSentEvent)result, trailers);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static ServerSentEvent toSse(@Nullable Object content) {
        if (content == null) {
            return ServerSentEvent.empty();
        }
        if (content instanceof ServerSentEvent) {
            return (ServerSentEvent)content;
        }
        return ServerSentEvent.ofData(String.valueOf(content));
    }
}

