/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.auth;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthFailureHandler;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthSuccessHandler;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthorizationStatusImpl;

@UnstableApi
public interface AuthorizationStatus {
    public static AuthorizationStatus of(boolean isAuthorized) {
        return isAuthorized ? AuthorizationStatusImpl.SUCCESS : AuthorizationStatusImpl.FAILURE;
    }

    public static AuthorizationStatus ofSuccess() {
        return AuthorizationStatusImpl.SUCCESS;
    }

    public static AuthorizationStatus ofSuccess(@Nullable AuthSuccessHandler successHandler) {
        return new AuthorizationStatusImpl(successHandler);
    }

    public static AuthorizationStatus ofFailure(@Nullable AuthFailureHandler failureHandler) {
        return new AuthorizationStatusImpl(failureHandler);
    }

    public boolean isAuthorized();

    @Nullable
    public AuthSuccessHandler successHandler();

    @Nullable
    public AuthFailureHandler failureHandler();
}

