/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.auth;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthorizationStatus;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthorizerChain;
import java.util.concurrent.CompletionStage;

@FunctionalInterface
public interface Authorizer<T> {
    public CompletionStage<Boolean> authorize(ServiceRequestContext var1, T var2);

    @UnstableApi
    default public CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(ServiceRequestContext ctx, @Nullable T data) {
        if (data == null) {
            return UnmodifiableFuture.completedFuture(AuthorizationStatus.of(false));
        }
        return this.authorize(ctx, data).thenApply(b -> {
            if (b == null) {
                return null;
            }
            return AuthorizationStatus.of(b);
        });
    }

    default public Authorizer<T> orElse(Authorizer<T> nextAuthorizer) {
        Authorizer self = this;
        return new AuthorizerChain<T>(self, AuthorizerChain.AuthorizerSelectionStrategy.LAST_WITH_HANDLER).orElse(nextAuthorizer);
    }
}

