/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.auth;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthToken;
import io.opentelemetry.testing.internal.armeria.common.auth.OAuth2Token;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuth2TokenExtractor
implements Function<RequestHeaders, OAuth2Token> {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2TokenExtractor.class);
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("\\s*(?i)bearer\\s+(?<accessToken>\\S+)\\s*");
    private final AsciiString header;

    OAuth2TokenExtractor(CharSequence header) {
        this.header = HttpHeaderNames.of(header);
    }

    @Override
    @Nullable
    public OAuth2Token apply(RequestHeaders headers) {
        String authorization = Objects.requireNonNull(headers, "headers").get(this.header);
        if (Strings.isNullOrEmpty(authorization)) {
            return null;
        }
        Matcher matcher = AUTHORIZATION_HEADER_PATTERN.matcher(authorization);
        if (!matcher.matches()) {
            logger.warn("Invalid authorization header: " + authorization);
            return null;
        }
        return AuthToken.ofOAuth2(matcher.group("accessToken"));
    }
}

