/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.cors;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.annotation.AdditionalHeader;
import io.opentelemetry.testing.internal.armeria.server.annotation.decorator.CorsDecorator;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsConfig;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsPolicy;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

abstract class AbstractCorsPolicyBuilder<SELF extends AbstractCorsPolicyBuilder<SELF>> {
    private final Set<String> origins;
    private final Predicate<? super String> originPredicate;
    private final List<Route> routes = new ArrayList<Route>();
    private boolean credentialsAllowed;
    private boolean nullOriginAllowed;
    private long maxAge;
    private final Set<AsciiString> exposedHeaders = new HashSet<AsciiString>();
    private final EnumSet<HttpMethod> allowedRequestMethods = EnumSet.noneOf(HttpMethod.class);
    private boolean allowAllRequestHeaders;
    private final Set<AsciiString> allowedRequestHeaders = new HashSet<AsciiString>();
    private final Map<AsciiString, Supplier<?>> preflightResponseHeaders = new HashMap();
    private boolean preflightResponseHeadersDisabled;

    AbstractCorsPolicyBuilder(List<String> origins) {
        Objects.requireNonNull(origins, "origins");
        Preconditions.checkArgument(!origins.isEmpty(), "origins is empty.");
        for (int i = 0; i < origins.size(); ++i) {
            if (origins.get(i) != null) continue;
            throw new NullPointerException("origins[" + i + ']');
        }
        this.origins = origins.stream().map(Ascii::toLowerCase).collect(ImmutableSet.toImmutableSet());
        this.originPredicate = this.origins::contains;
    }

    AbstractCorsPolicyBuilder(Predicate<? super String> originPredicate) {
        Objects.requireNonNull(originPredicate, "originPredicate");
        this.origins = ImmutableSet.of();
        this.originPredicate = originPredicate;
    }

    final SELF self() {
        return (SELF)this;
    }

    final void setConfig(CorsDecorator corsDecorator) {
        Arrays.stream(corsDecorator.pathPatterns()).forEach(this::route);
        if (corsDecorator.credentialsAllowed()) {
            this.allowCredentials();
        }
        if (corsDecorator.nullOriginAllowed()) {
            this.allowNullOrigin();
        }
        if (corsDecorator.preflightRequestDisabled()) {
            this.disablePreflightResponseHeaders();
        }
        if (corsDecorator.exposedHeaders().length > 0) {
            this.exposeHeaders(corsDecorator.exposedHeaders());
        }
        if (corsDecorator.allowedRequestHeaders().length > 0) {
            this.allowRequestHeaders(corsDecorator.allowedRequestHeaders());
        }
        this.allowAllRequestHeaders(corsDecorator.allowAllRequestHeaders());
        if (corsDecorator.allowedRequestMethods().length > 0) {
            this.allowRequestMethods(corsDecorator.allowedRequestMethods());
        }
        for (AdditionalHeader additionalHeader : corsDecorator.preflightRequestHeaders()) {
            this.preflightResponseHeader((CharSequence)additionalHeader.name(), additionalHeader.value());
        }
        if (corsDecorator.maxAge() > 0L) {
            this.maxAge(corsDecorator.maxAge());
        }
    }

    public SELF route(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        this.routes.add(Route.builder().path(pathPattern).build());
        return this.self();
    }

    public SELF allowNullOrigin() {
        this.nullOriginAllowed = true;
        return this.self();
    }

    public SELF allowCredentials() {
        this.credentialsAllowed = true;
        return this.self();
    }

    public SELF maxAge(long maxAge) {
        Preconditions.checkState(maxAge > 0L, "maxAge: %s (expected: > 0)", maxAge);
        this.maxAge = maxAge;
        return this.self();
    }

    public SELF exposeHeaders(CharSequence ... headers) {
        Objects.requireNonNull(headers, "headers");
        return this.exposeHeaders(ImmutableList.copyOf(headers));
    }

    public SELF exposeHeaders(Iterable<? extends CharSequence> headers) {
        Objects.requireNonNull(headers, "headers");
        ArrayList copied = new ArrayList();
        Iterables.addAll(copied, headers);
        Preconditions.checkArgument(!copied.isEmpty(), "headers should not be empty.");
        for (int i = 0; i < copied.size(); ++i) {
            if (copied.get(i) != null) continue;
            throw new NullPointerException("headers[" + i + ']');
        }
        copied.stream().map(HttpHeaderNames::of).forEach(this.exposedHeaders::add);
        return this.self();
    }

    public SELF allowRequestMethods(HttpMethod ... methods) {
        Objects.requireNonNull(methods, "methods");
        return this.allowRequestMethods(ImmutableList.copyOf(methods));
    }

    public SELF allowRequestMethods(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        ArrayList copied = new ArrayList();
        Iterables.addAll(copied, methods);
        Preconditions.checkArgument(!copied.isEmpty(), "methods should not be empty.");
        for (int i = 0; i < copied.size(); ++i) {
            if (copied.get(i) != null) continue;
            throw new NullPointerException("methods[" + i + ']');
        }
        this.allowedRequestMethods.addAll(copied);
        return this.self();
    }

    public SELF allowAllRequestHeaders(boolean allowAllRequestHeaders) {
        this.allowAllRequestHeaders = allowAllRequestHeaders;
        return this.self();
    }

    public SELF allowRequestHeaders(CharSequence ... headers) {
        Objects.requireNonNull(headers, "headers");
        return this.allowRequestHeaders(ImmutableList.copyOf(headers));
    }

    public SELF allowRequestHeaders(Iterable<? extends CharSequence> headers) {
        Objects.requireNonNull(headers, "headers");
        ArrayList copied = new ArrayList();
        Iterables.addAll(copied, headers);
        Preconditions.checkArgument(!copied.isEmpty(), "headers should not be empty.");
        for (int i = 0; i < copied.size(); ++i) {
            if (copied.get(i) != null) continue;
            throw new NullPointerException("headers[" + i + ']');
        }
        copied.stream().map(HttpHeaderNames::of).forEach(this.allowedRequestHeaders::add);
        return this.self();
    }

    public SELF preflightResponseHeader(CharSequence name, Object ... values) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(values, "values");
        Preconditions.checkArgument(values.length > 0, "values should not be empty.");
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("values[" + i + ']');
        }
        this.preflightResponseHeaders.put(HttpHeaderNames.of(name), new CorsConfig.ConstantValueSupplier(ImmutableList.copyOf(values)));
        return this.self();
    }

    public SELF preflightResponseHeader(CharSequence name, Iterable<?> values) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(values, "values");
        Preconditions.checkArgument(!Iterables.isEmpty(values), "values should not be empty.");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int i = 0;
        for (Object value : values) {
            if (value == null) {
                throw new NullPointerException("value[" + i + ']');
            }
            builder.add(value);
            ++i;
        }
        this.preflightResponseHeaders.put(HttpHeaderNames.of(name), new CorsConfig.ConstantValueSupplier(builder.build()));
        return this.self();
    }

    public SELF preflightResponseHeader(CharSequence name, Supplier<?> valueSupplier) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(valueSupplier, "valueSupplier");
        this.preflightResponseHeaders.put(HttpHeaderNames.of(name), valueSupplier);
        return this.self();
    }

    public SELF disablePreflightResponseHeaders() {
        this.preflightResponseHeadersDisabled = true;
        return this.self();
    }

    CorsPolicy build() {
        return new CorsPolicy(this.origins, this.originPredicate, this.routes, this.credentialsAllowed, this.maxAge, this.nullOriginAllowed, this.exposedHeaders, this.allowAllRequestHeaders, this.allowedRequestHeaders, this.allowedRequestMethods, this.preflightResponseHeadersDisabled, this.preflightResponseHeaders);
    }

    public String toString() {
        return CorsPolicy.toString(this, this.origins, this.routes, this.nullOriginAllowed, this.credentialsAllowed, this.maxAge, this.exposedHeaders, this.allowedRequestMethods, this.allowAllRequestHeaders, this.allowedRequestHeaders, this.preflightResponseHeaders);
    }
}

