/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.cors;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.CorsHeaderUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsConfig;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsPolicy;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsServiceBuilder;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorsService
extends SimpleDecoratingHttpService {
    private static final Logger logger = LoggerFactory.getLogger(CorsService.class);
    private final CorsConfig config;

    public static CorsServiceBuilder builderForAnyOrigin() {
        return new CorsServiceBuilder();
    }

    public static CorsServiceBuilder builder(String ... origins) {
        return CorsService.builder(ImmutableList.copyOf(Objects.requireNonNull(origins, "origins")));
    }

    public static CorsServiceBuilder builder(Iterable<String> origins) {
        Objects.requireNonNull(origins, "origins");
        ImmutableList<String> copied = ImmutableList.copyOf(origins);
        if (copied.contains("*")) {
            if (copied.size() > 1) {
                logger.warn("Any origin (*) has been already included. Other origins ({}) will be ignored.", (Object)copied.stream().filter(c -> !"*".equals(c)).collect(Collectors.joining(",")));
            }
            return CorsService.builderForAnyOrigin();
        }
        return new CorsServiceBuilder(copied);
    }

    @UnstableApi
    public static CorsServiceBuilder builder(Predicate<? super String> originPredicate) {
        Objects.requireNonNull(originPredicate, "originPredicate");
        return new CorsServiceBuilder(originPredicate);
    }

    @UnstableApi
    public static CorsServiceBuilder builderForOriginRegex(String originRegex) {
        Objects.requireNonNull(originRegex, "originRegex");
        return CorsService.builderForOriginRegex(Pattern.compile(originRegex));
    }

    @UnstableApi
    public static CorsServiceBuilder builderForOriginRegex(Pattern originRegex) {
        return CorsService.builder(Objects.requireNonNull(originRegex, "originRegex").asPredicate());
    }

    CorsService(HttpService delegate, CorsConfig config) {
        super(delegate);
        this.config = Objects.requireNonNull(config, "config");
    }

    public CorsConfig config() {
        return this.config;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (ArmeriaHttpUtil.isCorsPreflightRequest(req.headers())) {
            return this.handleCorsPreflight(ctx, req);
        }
        if (this.config.isShortCircuit() && this.config.getPolicy(req.headers().get(HttpHeaderNames.ORIGIN), ctx.routingContext()) == null) {
            return CorsService.forbidden();
        }
        return ((HttpResponse)((Service)this.unwrap()).serve(ctx, req)).mapHeaders(headers -> {
            ResponseHeadersBuilder builder = headers.toBuilder();
            CorsHeaderUtil.setCorsResponseHeaders(ctx, req, builder, this.config);
            return builder.build();
        });
    }

    private HttpResponse handleCorsPreflight(ServiceRequestContext ctx, HttpRequest req) {
        ResponseHeadersBuilder headers = ResponseHeaders.builder(HttpStatus.OK);
        CorsPolicy policy = CorsHeaderUtil.setCorsOrigin(ctx, req, headers, this.config);
        if (policy != null) {
            policy.setCorsAllowMethods(headers);
            RequestHeaders requestHeaders = req.headers();
            CorsHeaderUtil.setCorsAllowHeaders(requestHeaders, headers, policy);
            CorsHeaderUtil.setCorsAllowCredentials(headers, policy);
            policy.setCorsMaxAge(headers);
            policy.setCorsPreflightResponseHeaders(headers);
        }
        return HttpResponse.of(headers.build());
    }

    private static HttpResponse forbidden() {
        return HttpResponse.of(HttpStatus.FORBIDDEN);
    }
}

