/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Joiner;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.docs.DefaultTypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignatureType;
import java.util.List;
import java.util.Objects;

@UnstableApi
public class ContainerTypeSignature
extends DefaultTypeSignature {
    private static final Joiner JOINER = Joiner.on(", ");
    private final List<TypeSignature> typeParameters;

    ContainerTypeSignature(TypeSignatureType type, String name, List<TypeSignature> typeParameters) {
        super(type, name);
        ImmutableList<TypeSignature> typeParametersCopy = ImmutableList.copyOf(typeParameters);
        Preconditions.checkArgument(!typeParametersCopy.isEmpty(), "typeParameters is empty.");
        this.typeParameters = typeParametersCopy;
    }

    public List<TypeSignature> typeParameters() {
        return this.typeParameters;
    }

    @Override
    public String signature() {
        return this.name() + '<' + JOINER.join(this.typeParameters) + '>';
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerTypeSignature)) {
            return false;
        }
        ContainerTypeSignature that = (ContainerTypeSignature)o;
        return this.type() == that.type() && this.name().equals(that.name()) && Objects.equals(this.typeParameters, that.typeParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.name(), this.typeParameters});
    }
}

