/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.server.docs.DocServiceUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ArrayListMultimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ListMultimap;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptiveTypeInfoProvider;
import io.opentelemetry.testing.internal.armeria.server.docs.DocService;
import io.opentelemetry.testing.internal.armeria.server.docs.DocServiceFilter;
import io.opentelemetry.testing.internal.armeria.server.docs.DocServicePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public final class DocServiceBuilder {
    static final DocServiceFilter ALL_SERVICES = (plugin, service, method) -> true;
    static final DocServiceFilter NO_SERVICE = (plugin, service, method) -> false;
    private DocServiceFilter includeFilter = ALL_SERVICES;
    private DocServiceFilter excludeFilter = NO_SERVICE;
    private final Map<String, ListMultimap<String, HttpHeaders>> exampleHeaders = new HashMap<String, ListMultimap<String, HttpHeaders>>();
    private final Map<String, ListMultimap<String, String>> exampleRequests = new HashMap<String, ListMultimap<String, String>>();
    private final Map<String, ListMultimap<String, String>> examplePaths = new HashMap<String, ListMultimap<String, String>>();
    private final Map<String, ListMultimap<String, String>> exampleQueries = new HashMap<String, ListMultimap<String, String>>();
    private final List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers = new ArrayList<BiFunction<ServiceRequestContext, HttpRequest, String>>();
    @Nullable
    private DescriptiveTypeInfoProvider descriptiveTypeInfoProvider;

    DocServiceBuilder() {
    }

    public DocServiceBuilder exampleHeaders(HttpHeaders ... exampleHeaders) {
        Objects.requireNonNull(exampleHeaders, "exampleHeaders");
        return this.exampleHeaders(ImmutableList.copyOf(exampleHeaders));
    }

    public DocServiceBuilder exampleHeaders(Iterable<? extends HttpHeaders> exampleHeaders) {
        return this.exampleHeaders0("", "", exampleHeaders);
    }

    public DocServiceBuilder exampleHeaders(Class<?> serviceType, HttpHeaders ... exampleHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHeaders(serviceType.getName(), exampleHeaders);
    }

    public DocServiceBuilder exampleHeaders(Class<?> serviceType, Iterable<? extends HttpHeaders> exampleHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHeaders(serviceType.getName(), exampleHeaders);
    }

    public DocServiceBuilder exampleHeaders(String serviceName, HttpHeaders ... exampleHeaders) {
        Objects.requireNonNull(exampleHeaders, "exampleHeaders");
        return this.exampleHeaders(serviceName, ImmutableList.copyOf(exampleHeaders));
    }

    public DocServiceBuilder exampleHeaders(String serviceName, Iterable<? extends HttpHeaders> exampleHeaders) {
        Objects.requireNonNull(serviceName, "serviceName");
        Preconditions.checkArgument(!serviceName.isEmpty(), "serviceName is empty.");
        Objects.requireNonNull(exampleHeaders, "exampleHeaders");
        return this.exampleHeaders0(serviceName, "", exampleHeaders);
    }

    public DocServiceBuilder exampleHeaders(Class<?> serviceType, String methodName, HttpHeaders ... exampleHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHeaders(serviceType.getName(), methodName, exampleHeaders);
    }

    public DocServiceBuilder exampleHeaders(Class<?> serviceType, String methodName, Iterable<? extends HttpHeaders> exampleHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHeaders(serviceType.getName(), methodName, exampleHeaders);
    }

    public DocServiceBuilder exampleHeaders(String serviceName, String methodName, HttpHeaders ... exampleHeaders) {
        Objects.requireNonNull(exampleHeaders, "exampleHeaders");
        return this.exampleHeaders(serviceName, methodName, ImmutableList.copyOf(exampleHeaders));
    }

    public DocServiceBuilder exampleHeaders(String serviceName, String methodName, Iterable<? extends HttpHeaders> exampleHeaders) {
        Objects.requireNonNull(serviceName, "serviceName");
        Preconditions.checkArgument(!serviceName.isEmpty(), "serviceName is empty.");
        Objects.requireNonNull(methodName, "methodName");
        Preconditions.checkArgument(!methodName.isEmpty(), "methodName is empty.");
        Objects.requireNonNull(exampleHeaders, "exampleHeaders");
        return this.exampleHeaders0(serviceName, methodName, exampleHeaders);
    }

    private DocServiceBuilder exampleHeaders0(String serviceName, String methodName, Iterable<? extends HttpHeaders> exampleHeaders) {
        for (HttpHeaders httpHeaders : exampleHeaders) {
            Objects.requireNonNull(httpHeaders, "exampleHeaders contains null.");
            this.exampleHeaders.computeIfAbsent(serviceName, unused -> ArrayListMultimap.create()).put(methodName, httpHeaders);
        }
        return this;
    }

    public DocServiceBuilder examplePaths(Class<?> serviceType, String methodName, String ... paths) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.examplePaths(serviceType.getName(), methodName, paths);
    }

    public DocServiceBuilder examplePaths(Class<?> serviceType, String methodName, Iterable<String> paths) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.examplePaths(serviceType.getName(), methodName, paths);
    }

    public DocServiceBuilder examplePaths(String serviceName, String methodName, String ... paths) {
        Objects.requireNonNull(paths, "paths");
        return this.examplePaths(serviceName, methodName, ImmutableList.copyOf(paths));
    }

    public DocServiceBuilder examplePaths(String serviceName, String methodName, Iterable<String> paths) {
        Objects.requireNonNull(serviceName, "serviceName");
        Preconditions.checkArgument(!serviceName.isEmpty(), "serviceName is empty.");
        Objects.requireNonNull(methodName, "methodName");
        Preconditions.checkArgument(!methodName.isEmpty(), "methodName is empty.");
        Objects.requireNonNull(paths, "paths");
        for (String examplePath : paths) {
            Objects.requireNonNull(examplePath, "paths contains null");
            this.examplePaths.computeIfAbsent(serviceName, unused -> ArrayListMultimap.create()).put(methodName, examplePath);
        }
        return this;
    }

    public DocServiceBuilder exampleQueries(Class<?> serviceType, String methodName, String ... queryStrings) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleQueries(serviceType.getName(), methodName, queryStrings);
    }

    public DocServiceBuilder exampleQueries(Class<?> serviceType, String methodName, Iterable<String> queryStrings) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleQueries(serviceType.getName(), methodName, queryStrings);
    }

    public DocServiceBuilder exampleQueries(String serviceName, String methodName, String ... queryStrings) {
        Objects.requireNonNull(queryStrings, "queryStrings");
        return this.exampleQueries(serviceName, methodName, ImmutableList.copyOf(queryStrings));
    }

    public DocServiceBuilder exampleQueries(String serviceName, String methodName, Iterable<String> queryStrings) {
        Objects.requireNonNull(serviceName, "serviceName");
        Preconditions.checkArgument(!serviceName.isEmpty(), "serviceName is empty.");
        Objects.requireNonNull(methodName, "methodName");
        Preconditions.checkArgument(!methodName.isEmpty(), "methodName is empty.");
        Objects.requireNonNull(queryStrings, "queryStrings");
        for (String query : queryStrings) {
            Objects.requireNonNull(query, "queryStrings contains null");
            this.exampleQueries.computeIfAbsent(serviceName, unused -> ArrayListMultimap.create()).put(methodName, query);
        }
        return this;
    }

    public DocServiceBuilder exampleRequests(Class<?> serviceType, String methodName, Object ... exampleRequests) {
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        return this.exampleRequests(serviceType, methodName, ImmutableList.copyOf(exampleRequests));
    }

    public DocServiceBuilder exampleRequests(Class<?> serviceType, String methodName, Iterable<?> exampleRequests) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleRequests(serviceType.getName(), methodName, exampleRequests);
    }

    public DocServiceBuilder exampleRequests(String serviceName, String methodName, Object ... exampleRequests) {
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        return this.exampleRequests(serviceName, methodName, ImmutableList.copyOf(exampleRequests));
    }

    public DocServiceBuilder exampleRequests(String serviceName, String methodName, Iterable<?> exampleRequests) {
        Objects.requireNonNull(serviceName, "serviceName");
        Objects.requireNonNull(methodName, "methodName");
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        for (Object e : exampleRequests) {
            Objects.requireNonNull(e, "exampleRequests contains null.");
            this.putExampleRequest(serviceName, methodName, DocServiceBuilder.serializeExampleRequest(serviceName, methodName, e));
        }
        return this;
    }

    public DocServiceBuilder exampleRequests(Iterable<?> exampleRequests) {
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        for (Object e : exampleRequests) {
            Objects.requireNonNull(e, "exampleRequests contains null.");
            String[] result = DocServiceBuilder.guessAndSerializeExampleRequest(e);
            this.putExampleRequest(result[0], result[1], result[2]);
        }
        return this;
    }

    public DocServiceBuilder include(DocServiceFilter filter) {
        Objects.requireNonNull(filter, "filter");
        this.includeFilter = this.includeFilter == ALL_SERVICES ? filter : this.includeFilter.or(filter);
        return this;
    }

    public DocServiceBuilder exclude(DocServiceFilter filter) {
        Objects.requireNonNull(filter, "filter");
        this.excludeFilter = this.excludeFilter == NO_SERVICE ? filter : this.excludeFilter.or(filter);
        return this;
    }

    public DocServiceBuilder injectedScripts(String ... scripts) {
        Objects.requireNonNull(scripts, "scripts");
        return this.injectedScripts(ImmutableList.copyOf(scripts));
    }

    public DocServiceBuilder injectedScripts(Iterable<String> scripts) {
        Objects.requireNonNull(scripts, "scripts");
        for (String s : scripts) {
            Objects.requireNonNull(s, "scripts contains null.");
            this.injectedScriptSuppliers.add((unused1, unused2) -> s);
        }
        return this;
    }

    public DocServiceBuilder injectedScriptSupplier(BiFunction<ServiceRequestContext, HttpRequest, String> supplier) {
        this.injectedScriptSuppliers.add(Objects.requireNonNull(supplier, "supplier"));
        return this;
    }

    @UnstableApi
    public DocServiceBuilder descriptiveTypeInfoProvider(Iterable<? extends DescriptiveTypeInfoProvider> descriptiveTypeInfoProviders) {
        Objects.requireNonNull(descriptiveTypeInfoProviders, "descriptiveTypeInfoProviders");
        for (DescriptiveTypeInfoProvider descriptiveTypeInfoProvider : descriptiveTypeInfoProviders) {
            this.descriptiveTypeInfoProvider(descriptiveTypeInfoProvider);
        }
        return this;
    }

    @UnstableApi
    public DocServiceBuilder descriptiveTypeInfoProvider(DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
        Objects.requireNonNull(descriptiveTypeInfoProvider, "descriptiveTypeInfoProvider");
        if (this.descriptiveTypeInfoProvider == null) {
            this.descriptiveTypeInfoProvider = descriptiveTypeInfoProvider;
        } else {
            this.descriptiveTypeInfoProvider.orElse(descriptiveTypeInfoProvider);
        }
        return this;
    }

    private void putExampleRequest(String serviceName, String methodName, String serializedExampleRequest) {
        this.exampleRequests.computeIfAbsent(serviceName, unused -> ArrayListMultimap.create()).put(methodName, serializedExampleRequest);
    }

    private static String serializeExampleRequest(String serviceName, String methodName, Object exampleRequest) {
        if (exampleRequest instanceof CharSequence) {
            return exampleRequest.toString();
        }
        for (DocServicePlugin plugin : DocService.plugins) {
            String result;
            if (plugin.supportedExampleRequestTypes().stream().noneMatch(type -> type.isInstance(exampleRequest)) || (result = plugin.serializeExampleRequest(serviceName, methodName, exampleRequest)) == null) continue;
            return result;
        }
        throw new IllegalArgumentException("could not find a plugin that can serialize: " + exampleRequest);
    }

    private static String[] guessAndSerializeExampleRequest(Object exampleRequest) {
        Preconditions.checkArgument(!(exampleRequest instanceof CharSequence), "can't guess service or method name from a string: %s", exampleRequest);
        boolean guessed = false;
        for (DocServicePlugin plugin : DocService.plugins) {
            if (plugin.supportedExampleRequestTypes().stream().noneMatch(type -> type.isInstance(exampleRequest))) continue;
            String serviceName = plugin.guessServiceName(exampleRequest);
            String methodName = plugin.guessServiceMethodName(exampleRequest);
            if (serviceName == null || methodName == null) continue;
            guessed = true;
            String serialized = plugin.serializeExampleRequest(serviceName, methodName, exampleRequest);
            if (serialized == null) continue;
            return new String[]{serviceName, methodName, serialized};
        }
        if (guessed) {
            throw new IllegalArgumentException("could not find a plugin that can serialize: " + exampleRequest);
        }
        throw new IllegalArgumentException("could not find a plugin that can guess the service and method name from: " + exampleRequest);
    }

    public DocService build() {
        return new DocService(this.exampleHeaders, this.exampleRequests, this.examplePaths, this.exampleQueries, this.injectedScriptSuppliers, DocServiceUtil.unifyFilter(this.includeFilter, this.excludeFilter), this.descriptiveTypeInfoProvider);
    }
}

