/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.encoding;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoderFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.encoding.HttpDecodedRequest;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class DecodingService
extends SimpleDecoratingHttpService {
    private final Map<String, StreamDecoderFactory> decoderFactories;

    public static Function<? super HttpService, DecodingService> newDecorator() {
        return DecodingService.newDecorator(StreamDecoderFactory.all());
    }

    public static Function<? super HttpService, DecodingService> newDecorator(StreamDecoderFactory ... decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        return DecodingService.newDecorator(ImmutableList.copyOf(decoderFactories));
    }

    public static Function<? super HttpService, DecodingService> newDecorator(Iterable<? extends StreamDecoderFactory> decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        ImmutableList<? extends StreamDecoderFactory> immutableDecoderFactories = ImmutableList.copyOf(decoderFactories);
        return delegate -> new DecodingService((HttpService)delegate, (Iterable<? extends StreamDecoderFactory>)immutableDecoderFactories);
    }

    private DecodingService(HttpService delegate, Iterable<? extends StreamDecoderFactory> decoderFactories) {
        super(delegate);
        this.decoderFactories = Streams.stream(decoderFactories).collect(ImmutableMap.toImmutableMap(StreamDecoderFactory::encodingHeaderValue, Function.identity()));
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        RequestHeaders headers = req.headers();
        String contentEncoding = headers.get(HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        StreamDecoderFactory decoderFactory = this.decoderFactories.get(Ascii.toLowerCase(contentEncoding));
        if (decoderFactory == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        RequestHeaders newHeaders = headers.toBuilder().removeAndThen(HttpHeaderNames.CONTENT_ENCODING).removeAndThen(HttpHeaderNames.CONTENT_LENGTH).build();
        HttpRequest newReq = req.withHeaders(newHeaders);
        HttpDecodedRequest decodedRequest = new HttpDecodedRequest(newReq, decoderFactory, ctx.alloc(), Ints.saturatedCast(ctx.maxRequestLength()));
        ctx.updateRequest(decodedRequest);
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, decodedRequest);
    }
}

