/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.encoding.StaticHttpDecodedResponse;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.file.AggregatedHttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.FileService;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFileAttributes;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

final class DecompressingHttpFile
implements HttpFile {
    private final HttpFile compressedFile;
    private final FileService.ContentEncoding encoding;
    @Nullable
    private final MediaType contentType;

    DecompressingHttpFile(HttpFile compressedFile, FileService.ContentEncoding encoding, @Nullable MediaType contentType) {
        this.compressedFile = compressedFile;
        this.encoding = encoding;
        this.contentType = contentType;
    }

    @Override
    public CompletableFuture<@Nullable HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return this.compressedFile.readAttributes(fileReadExecutor);
    }

    @Override
    public CompletableFuture<@Nullable ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return this.compressedFile.readHeaders(fileReadExecutor);
    }

    @Override
    public CompletableFuture<@Nullable HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.compressedFile.read(fileReadExecutor, alloc);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        return this.compressedFile.aggregate(fileReadExecutor);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.compressedFile.aggregateWithPooledObjects(fileReadExecutor, alloc);
    }

    @Override
    public HttpService asService() {
        return (ctx, req) -> {
            HttpResponse response = this.compressedFile.asService().serve(ctx, req);
            return new StaticHttpDecodedResponse(response, this.encoding.decoderFactory.newDecoder(ctx.alloc()), this.contentType);
        };
    }
}

