/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponseWriter;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopCheckingFuture;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.server.file.AbstractHttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.AggregatedHttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.AggregatedHttpFileBuilder;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFileAttributes;
import io.opentelemetry.testing.internal.armeria.server.file.NonExistentAggregatedHttpFile;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamingHttpFile<T extends Closeable>
extends AbstractHttpFile {
    private static final Logger logger = LoggerFactory.getLogger(StreamingHttpFile.class);
    private static final int MAX_CHUNK_SIZE = 8192;
    private static final UnmodifiableFuture<AggregatedHttpFile> NON_EXISTENT_FILE_FUTURE = UnmodifiableFuture.completedFuture(NonExistentAggregatedHttpFile.INSTANCE);

    protected StreamingHttpFile(@Nullable MediaType contentType, Clock clock, boolean dateEnabled, boolean lastModifiedEnabled, @Nullable BiFunction<String, HttpFileAttributes, String> entityTagFunction, HttpHeaders headers) {
        super(contentType, clock, dateEnabled, lastModifiedEnabled, entityTagFunction, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final HttpResponse doRead(ResponseHeaders headers, long length, Executor fileReadExecutor, ByteBufAllocator alloc) throws IOException {
        T in = this.newStream();
        if (in == null) {
            return null;
        }
        boolean submitted = false;
        try {
            HttpResponseWriter res = HttpResponse.streaming();
            res.write(headers);
            fileReadExecutor.execute(() -> this.doRead(res, in, 0L, length, fileReadExecutor, alloc));
            submitted = true;
            HttpResponseWriter httpResponseWriter = res;
            return httpResponseWriter;
        }
        finally {
            if (!submitted) {
                this.close((Closeable)in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(HttpResponseWriter res, T in, long offset, long end, Executor fileReadExecutor, ByteBufAllocator alloc) {
        boolean endOfStream;
        int readBytes;
        int chunkSize = (int)Math.min(8192L, end - offset);
        ByteBuf buf = alloc.buffer(chunkSize);
        boolean success = false;
        try {
            readBytes = this.read(in, buf);
            if (readBytes < 0) {
                throw new EOFException();
            }
            success = true;
        }
        catch (Exception e) {
            this.close(res, (Closeable)in, e);
            return;
        }
        finally {
            if (!success) {
                buf.release();
            }
        }
        long nextOffset = offset + (long)readBytes;
        boolean bl = endOfStream = nextOffset == end;
        if (readBytes > 0) {
            if (!res.tryWrite(HttpData.wrap(buf).withEndOfStream(endOfStream))) {
                this.close((Closeable)in);
                return;
            }
        } else {
            buf.release();
        }
        if (endOfStream) {
            this.close(res, (Closeable)in);
            return;
        }
        res.whenConsumed().thenRun(() -> {
            try {
                fileReadExecutor.execute(() -> this.doRead(res, in, nextOffset, end, fileReadExecutor, alloc));
            }
            catch (Exception e) {
                this.close(res, (Closeable)in, e);
            }
        });
    }

    @Override
    public final CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        return this.doAggregate(fileReadExecutor, null);
    }

    @Override
    public final CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        Objects.requireNonNull(alloc, "alloc");
        return this.doAggregate(fileReadExecutor, alloc);
    }

    private CompletableFuture<AggregatedHttpFile> doAggregate(Executor fileReadExecutor, @Nullable ByteBufAllocator alloc) {
        return this.readAttributes(fileReadExecutor).thenCompose(attrs -> {
            T in;
            if (attrs == null) {
                return NON_EXISTENT_FILE_FUTURE;
            }
            if (attrs.length() > Integer.MAX_VALUE) {
                return UnmodifiableFuture.exceptionallyCompletedFuture(new IOException("too large to aggregate: " + attrs.length() + " bytes"));
            }
            try {
                in = this.newStream();
            }
            catch (IOException e) {
                return (CompletionStage)Exceptions.throwUnsafely(e);
            }
            if (in == null) {
                return NON_EXISTENT_FILE_FUTURE;
            }
            boolean submitted = false;
            try {
                EventLoopCheckingFuture future = new EventLoopCheckingFuture();
                fileReadExecutor.execute(() -> {
                    ByteBuf buf;
                    byte[] array;
                    int length = (int)attrs.length();
                    if (alloc != null) {
                        array = null;
                        buf = alloc.buffer(length);
                    } else {
                        array = new byte[length];
                        buf = Unpooled.wrappedBuffer(array).clear();
                    }
                    boolean success = false;
                    try {
                        String etag;
                        int readBytes;
                        int offset = 0;
                        do {
                            if ((readBytes = this.read(in, buf)) >= 0) continue;
                            throw new EOFException();
                        } while ((offset += readBytes) != length);
                        HttpData data = (array != null ? HttpData.wrap(array) : HttpData.wrap(buf)).withEndOfStream();
                        AggregatedHttpFileBuilder builder = AggregatedHttpFile.builder(data, attrs.lastModifiedMillis()).date(this.isDateEnabled()).lastModified(this.isLastModifiedEnabled());
                        if (this.contentType() != null) {
                            builder.contentType(this.contentType());
                        }
                        if ((etag = this.generateEntityTag((HttpFileAttributes)attrs)) != null) {
                            builder.entityTag((unused1, unused2) -> etag);
                        } else {
                            builder.entityTag(false);
                        }
                        builder.setHeaders((Iterable)this.additionalHeaders());
                        success = future.complete(builder.build());
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                    finally {
                        this.close((Closeable)in);
                        if (!success) {
                            buf.release();
                        }
                    }
                });
                submitted = true;
                EventLoopCheckingFuture eventLoopCheckingFuture = future;
                return eventLoopCheckingFuture;
            }
            finally {
                if (!submitted) {
                    this.close((Closeable)in);
                }
            }
        });
    }

    @Nullable
    protected abstract T newStream() throws IOException;

    protected abstract int read(T var1, ByteBuf var2) throws IOException;

    private void close(HttpResponseWriter res, Closeable in) {
        this.close(in);
        res.close();
    }

    private void close(HttpResponseWriter res, Closeable in, Exception cause) {
        this.close(in);
        res.close(cause);
    }

    private void close(Closeable in) {
        try {
            in.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close a stream for: {}", (Object)this, (Object)e);
        }
    }
}

