/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.healthcheck;

import io.opentelemetry.testing.internal.armeria.common.util.AbstractListenable;
import io.opentelemetry.testing.internal.armeria.server.healthcheck.HealthChecker;
import io.opentelemetry.testing.internal.armeria.server.healthcheck.ListenableHealthChecker;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public final class SettableHealthChecker
extends AbstractListenable<HealthChecker>
implements ListenableHealthChecker {
    private final AtomicBoolean isHealthy;

    public SettableHealthChecker() {
        this(true);
    }

    public SettableHealthChecker(boolean isHealthy) {
        this.isHealthy = new AtomicBoolean(isHealthy);
    }

    @Override
    public boolean isHealthy() {
        return this.isHealthy.get();
    }

    public SettableHealthChecker setHealthy(boolean isHealthy) {
        boolean oldValue = this.isHealthy.getAndSet(isHealthy);
        if (oldValue != isHealthy) {
            this.notifyListeners(this);
        }
        return this;
    }

    @Override
    @Nonnull
    protected HealthChecker latestValue() {
        return this;
    }

    public String toString() {
        return "SettableHealthChecker: " + (this.isHealthy.get() ? "healthy" : "not healthy");
    }
}

