/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.observation;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextExtension;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.TransientServiceOption;
import io.opentelemetry.testing.internal.armeria.server.observation.DefaultServiceObservationConvention;
import io.opentelemetry.testing.internal.armeria.server.observation.HttpServiceObservationDocumentation;
import io.opentelemetry.testing.internal.armeria.server.observation.ServiceObservationContext;
import io.opentelemetry.testing.internal.io.micrometer.observation.Observation;
import io.opentelemetry.testing.internal.io.micrometer.observation.ObservationConvention;
import io.opentelemetry.testing.internal.io.micrometer.observation.ObservationRegistry;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

@UnstableApi
public final class ObservationService
extends SimpleDecoratingHttpService {
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ObservationConvention<ServiceObservationContext> observationConvention;

    public static Function<? super HttpService, ObservationService> newDecorator(ObservationRegistry observationRegistry) {
        Objects.requireNonNull(observationRegistry, "observationRegistry");
        return service -> new ObservationService((HttpService)service, observationRegistry, null);
    }

    public static Function<? super HttpService, ObservationService> newDecorator(ObservationRegistry observationRegistry, ObservationConvention<ServiceObservationContext> observationConvention) {
        Objects.requireNonNull(observationRegistry, "observationRegistry");
        Objects.requireNonNull(observationConvention, "observationConvention");
        return service -> new ObservationService((HttpService)service, observationRegistry, observationConvention);
    }

    private ObservationService(HttpService delegate, ObservationRegistry observationRegistry, @Nullable ObservationConvention<ServiceObservationContext> observationConvention) {
        super(delegate);
        this.observationRegistry = Objects.requireNonNull(observationRegistry, "observationRegistry");
        this.observationConvention = observationConvention;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Set<TransientServiceOption> transientServiceOptions = ctx.config().transientServiceOptions();
        if (!transientServiceOptions.contains((Object)TransientServiceOption.WITH_TRACING) || !transientServiceOptions.contains((Object)TransientServiceOption.WITH_METRIC_COLLECTION)) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        ServiceObservationContext serviceObservationContext = new ServiceObservationContext(ctx, req);
        Observation observation = HttpServiceObservationDocumentation.OBSERVATION.observation(this.observationConvention, DefaultServiceObservationConvention.INSTANCE, () -> serviceObservationContext, this.observationRegistry).start();
        RequestContextExtension ctxExtension = ctx.as(RequestContextExtension.class);
        if (this.observationRegistry.isNoop() || observation.isNoop()) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        if (ctxExtension != null) {
            ctxExtension.hook(observation::openScope);
        }
        ObservationService.enrichObservation(ctx, serviceObservationContext, observation);
        return observation.scopedChecked(() -> (HttpResponse)((Service)this.unwrap()).serve(ctx, req));
    }

    private static void enrichObservation(ServiceRequestContext ctx, ServiceObservationContext serviceObservationContext, Observation observation) {
        ctx.log().whenAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(requestLog -> observation.event(HttpServiceObservationDocumentation.Events.WIRE_RECEIVE));
        ctx.log().whenAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(requestLog -> {
            if (requestLog.responseFirstBytesTransferredTimeNanos() != null) {
                observation.event(HttpServiceObservationDocumentation.Events.WIRE_SEND);
            }
        });
        ctx.log().whenComplete().thenAccept(requestLog -> {
            serviceObservationContext.setResponse(requestLog);
            observation.stop();
        });
    }
}

