/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.testing.junit5.server;

import io.opentelemetry.testing.internal.armeria.client.BlockingWebClient;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.RestClient;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.WebClientBuilder;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.testing.ServerRuleDelegate;
import io.opentelemetry.testing.internal.armeria.server.Server;
import io.opentelemetry.testing.internal.armeria.server.ServerBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.testing.junit5.common.AbstractAllOrEachExtension;
import io.opentelemetry.testing.internal.armeria.testing.server.ServiceRequestContextCaptor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class ServerExtension
extends AbstractAllOrEachExtension {
    private final ServiceRequestContextCaptor contextCaptor = new ServiceRequestContextCaptor();
    private final ServerRuleDelegate delegate;

    protected ServerExtension() {
        this(true);
    }

    protected ServerExtension(boolean autoStart) {
        this.delegate = new ServerRuleDelegate(autoStart){

            @Override
            public void configure(ServerBuilder sb) throws Exception {
                ServerExtension.this.configure(sb);
                sb.decorator((Function)ServerExtension.this.contextCaptor.newDecorator(ServerExtension.this::shouldCapture));
            }

            @Override
            public void configureWebClient(WebClientBuilder wcb) throws Exception {
                ServerExtension.this.configureWebClient(wcb);
            }
        };
    }

    @Override
    public void before(ExtensionContext context) throws Exception {
        try {
            this.delegate.before();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to set up before callback", t);
        }
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        super.beforeEach(context);
        this.contextCaptor.clear();
    }

    @Override
    public void after(ExtensionContext context) throws Exception {
        this.delegate.after();
    }

    public Server start() {
        return this.delegate.start();
    }

    protected abstract void configure(ServerBuilder var1) throws Exception;

    protected void configureWebClient(WebClientBuilder webClientBuilder) throws Exception {
    }

    public CompletableFuture<Void> stop() {
        return this.delegate.stop();
    }

    public Server server() {
        return this.delegate.server();
    }

    public int httpPort() {
        return this.delegate.httpPort();
    }

    public int httpsPort() {
        return this.delegate.httpsPort();
    }

    public int port(SessionProtocol protocol) {
        return this.delegate.port(protocol);
    }

    public boolean hasHttp() {
        return this.delegate.hasHttp();
    }

    public boolean hasHttps() {
        return this.delegate.hasHttps();
    }

    public Endpoint endpoint(SessionProtocol protocol) {
        return this.delegate.endpoint(protocol);
    }

    public Endpoint httpEndpoint() {
        return this.delegate.httpEndpoint();
    }

    public Endpoint httpsEndpoint() {
        return this.delegate.httpsEndpoint();
    }

    public URI uri(SessionProtocol protocol) {
        return this.delegate.uri(protocol);
    }

    public URI uri(SessionProtocol protocol, SerializationFormat format) {
        return this.delegate.uri(protocol, format);
    }

    public URI httpUri() {
        return this.delegate.httpUri();
    }

    public URI httpUri(SerializationFormat format) {
        return this.delegate.httpUri(format);
    }

    public URI httpsUri() {
        return this.delegate.httpsUri();
    }

    public URI httpsUri(SerializationFormat format) {
        return this.delegate.httpsUri(format);
    }

    public InetSocketAddress socketAddress(SessionProtocol protocol) {
        return this.delegate.socketAddress(protocol);
    }

    public InetSocketAddress httpSocketAddress() {
        return this.delegate.httpSocketAddress();
    }

    public InetSocketAddress httpsSocketAddress() {
        return this.delegate.httpsSocketAddress();
    }

    public final ServiceRequestContextCaptor requestContextCaptor() {
        return this.contextCaptor;
    }

    public WebClient webClient() {
        return this.delegate.webClient();
    }

    public WebClient webClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.delegate.webClient(webClientCustomizer);
    }

    @UnstableApi
    public BlockingWebClient blockingWebClient() {
        return this.delegate.blockingWebClient();
    }

    @UnstableApi
    public BlockingWebClient blockingWebClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.delegate.blockingWebClient(webClientCustomizer);
    }

    @UnstableApi
    public RestClient restClient() {
        return this.delegate.restClient();
    }

    @UnstableApi
    public RestClient restClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.delegate.restClient(webClientCustomizer);
    }

    @UnstableApi
    protected boolean shouldCapture(ServiceRequestContext ctx) {
        return true;
    }
}

