/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.netty.resolver.dns;

import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsQuestion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecord;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecordType;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsCnameCache;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsNameResolver;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsResolveContext;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsServerAddressStream;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.NoopDnsCnameCache;
import io.opentelemetry.testing.internal.io.netty.util.ReferenceCountUtil;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Future;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Promise;
import java.net.UnknownHostException;
import java.util.List;

final class DnsRecordResolveContext
extends DnsResolveContext<DnsRecord> {
    DnsRecordResolveContext(DnsNameResolver parent, Channel channel, Future<? extends Channel> channelReadyFuture, Promise<?> originalPromise, DnsQuestion question, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries) {
        this(parent, channel, channelReadyFuture, originalPromise, question.name(), question.dnsClass(), new DnsRecordType[]{question.type()}, additionals, nameServerAddrs, allowedQueries);
    }

    private DnsRecordResolveContext(DnsNameResolver parent, Channel channel, Future<? extends Channel> channelReadyFuture, Promise<?> originalPromise, String hostname, int dnsClass, DnsRecordType[] expectedTypes, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries) {
        super(parent, channel, channelReadyFuture, originalPromise, hostname, dnsClass, expectedTypes, additionals, nameServerAddrs, allowedQueries);
    }

    @Override
    DnsResolveContext<DnsRecord> newResolverContext(DnsNameResolver parent, Channel channel, Future<? extends Channel> channelReadyFuture, Promise<?> originalPromise, String hostname, int dnsClass, DnsRecordType[] expectedTypes, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries) {
        return new DnsRecordResolveContext(parent, channel, channelReadyFuture, originalPromise, hostname, dnsClass, expectedTypes, additionals, nameServerAddrs, allowedQueries);
    }

    @Override
    DnsRecord convertRecord(DnsRecord record, String hostname, DnsRecord[] additionals, EventLoop eventLoop) {
        return ReferenceCountUtil.retain(record);
    }

    @Override
    List<DnsRecord> filterResults(List<DnsRecord> unfiltered) {
        return unfiltered;
    }

    @Override
    boolean isCompleteEarly(DnsRecord resolved) {
        return false;
    }

    @Override
    boolean isDuplicateAllowed() {
        return true;
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, DnsRecord result, DnsRecord convertedResult) {
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, UnknownHostException cause) {
    }

    @Override
    DnsCnameCache cnameCache() {
        return NoopDnsCnameCache.INSTANCE;
    }
}

