/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jackson.datatype.jdk8;

import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.databind.JavaType;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import io.opentelemetry.testing.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.opentelemetry.testing.internal.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.opentelemetry.testing.internal.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.OptionalInt;

final class OptionalIntSerializer
extends StdScalarSerializer<OptionalInt> {
    private static final long serialVersionUID = 1L;
    static final OptionalIntSerializer INSTANCE = new OptionalIntSerializer();

    public OptionalIntSerializer() {
        super(OptionalInt.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalInt value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.INT);
        }
    }

    @Override
    public void serialize(OptionalInt value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            gen.writeNumber(value.getAsInt());
        } else {
            gen.writeNull();
        }
    }
}

