/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.CorrelationsContextUtils;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TracingContextUtils;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class Propagation
extends BaseShimObject {
    Propagation(TelemetryInfo telemetryInfo) {
        super(telemetryInfo);
    }

    public void injectTextFormat(SpanContextShim contextShim, TextMapInject carrier) {
        Context context = TracingContextUtils.withSpan((Span)DefaultSpan.create((SpanContext)contextShim.getSpanContext()), (Context)Context.current());
        context = CorrelationsContextUtils.withCorrelationContext((CorrelationContext)contextShim.getCorrelationContext(), (Context)context);
        this.propagators().getHttpTextFormat().inject(context, (Object)carrier, (HttpTextFormat.Setter)TextMapSetter.INSTANCE);
    }

    @Nullable
    public SpanContextShim extractTextFormat(TextMapExtract carrier) {
        HashMap carrierMap = new HashMap();
        for (Map.Entry entry : carrier) {
            carrierMap.put(entry.getKey(), entry.getValue());
        }
        Context context = this.propagators().getHttpTextFormat().extract(Context.current(), carrierMap, (HttpTextFormat.Getter)TextMapGetter.INSTANCE);
        Span span = TracingContextUtils.getSpan((Context)context);
        if (!span.getContext().isValid()) {
            return null;
        }
        return new SpanContextShim(this.telemetryInfo, span.getContext(), CorrelationsContextUtils.getCorrelationContext((Context)context));
    }

    static final class TextMapGetter
    implements HttpTextFormat.Getter<Map<String, String>> {
        public static final TextMapGetter INSTANCE = new TextMapGetter();

        private TextMapGetter() {
        }

        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key);
        }
    }

    static final class TextMapSetter
    implements HttpTextFormat.Setter<TextMapInject> {
        public static final TextMapSetter INSTANCE = new TextMapSetter();

        private TextMapSetter() {
        }

        public void set(TextMapInject carrier, String key, String value) {
            carrier.put(key, value);
        }
    }
}

