/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.ScopeShim;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;

final class ScopeManagerShim
extends BaseShimObject
implements ScopeManager {
    public ScopeManagerShim(TelemetryInfo telemetryInfo) {
        super(telemetryInfo);
    }

    public io.opentracing.Span activeSpan() {
        Span span = this.tracer().getCurrentSpan();
        if (DefaultSpan.getInvalid().equals(span)) {
            return null;
        }
        return new SpanShim(this.telemetryInfo(), span);
    }

    public Scope activate(io.opentracing.Span span) {
        Span actualSpan = ScopeManagerShim.getActualSpan(span);
        return new ScopeShim(this.tracer().withSpan(actualSpan));
    }

    static Span getActualSpan(io.opentracing.Span span) {
        if (!(span instanceof SpanShim)) {
            throw new IllegalArgumentException("span is not a valid SpanShim object");
        }
        return ((SpanShim)span).getSpan();
    }
}

