/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Status;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.List;

final class SpanBuilderShim
extends BaseShimObject
implements Tracer.SpanBuilder {
    private final String spanName;
    private SpanShim parentSpan;
    private SpanContextShim parentSpanContext;
    private boolean ignoreActiveSpan;
    private final List<SpanContext> parentLinks = new ArrayList<SpanContext>();
    private final List<String> spanBuilderAttributeKeys = new ArrayList<String>();
    private final List<AttributeValue> spanBuilderAttributeValues = new ArrayList<AttributeValue>();
    private Span.Kind spanKind;
    private boolean error;

    public SpanBuilderShim(TelemetryInfo telemetryInfo, String spanName) {
        super(telemetryInfo);
        this.spanName = spanName;
    }

    public Tracer.SpanBuilder asChildOf(Span parent) {
        if (parent == null) {
            return this;
        }
        SpanShim spanShim = SpanBuilderShim.getSpanShim(parent);
        if (this.parentSpan == null && this.parentSpanContext == null) {
            this.parentSpan = spanShim;
        } else {
            this.parentLinks.add(spanShim.getSpan().getContext());
        }
        return this;
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
        return this.addReference(null, parent);
    }

    public Tracer.SpanBuilder addReference(String referenceType, io.opentracing.SpanContext referencedContext) {
        if (referencedContext == null) {
            return this;
        }
        SpanContextShim contextShim = SpanBuilderShim.getContextShim(referencedContext);
        if (this.parentSpan == null && this.parentSpanContext == null) {
            this.parentSpanContext = contextShim;
        } else {
            this.parentLinks.add(contextShim.getSpanContext());
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        if (Tags.SPAN_KIND.getKey().equals(key)) {
            switch (value) {
                case "client": {
                    this.spanKind = Span.Kind.CLIENT;
                    break;
                }
                case "server": {
                    this.spanKind = Span.Kind.SERVER;
                    break;
                }
                case "producer": {
                    this.spanKind = Span.Kind.PRODUCER;
                    break;
                }
                case "consumer": {
                    this.spanKind = Span.Kind.CONSUMER;
                    break;
                }
                default: {
                    this.spanKind = Span.Kind.INTERNAL;
                    break;
                }
            }
        } else if (Tags.ERROR.getKey().equals(key)) {
            this.error = Boolean.parseBoolean(value);
        } else {
            this.spanBuilderAttributeKeys.add(key);
            this.spanBuilderAttributeValues.add(AttributeValue.stringAttributeValue((String)value));
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key)) {
            this.error = value;
        } else {
            this.spanBuilderAttributeKeys.add(key);
            this.spanBuilderAttributeValues.add(AttributeValue.booleanAttributeValue((boolean)value));
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            this.spanBuilderAttributeKeys.add(key);
            this.spanBuilderAttributeValues.add(AttributeValue.longAttributeValue((long)value.longValue()));
        } else if (value instanceof Float || value instanceof Double) {
            this.spanBuilderAttributeKeys.add(key);
            this.spanBuilderAttributeValues.add(AttributeValue.doubleAttributeValue((double)value.doubleValue()));
        } else {
            throw new IllegalArgumentException("Number type not supported");
        }
        return this;
    }

    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        if (value instanceof String) {
            this.withTag(tag.getKey(), (String)value);
        } else if (value instanceof Boolean) {
            this.withTag(tag.getKey(), (Boolean)value);
        } else if (value instanceof Number) {
            this.withTag(tag.getKey(), (Number)value);
        } else {
            this.withTag(tag.getKey(), value.toString());
        }
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        throw new UnsupportedOperationException();
    }

    public Span start() {
        CorrelationContext distContext = null;
        Span.Builder builder = this.tracer().spanBuilder(this.spanName);
        if (this.ignoreActiveSpan && this.parentSpan == null && this.parentSpanContext == null) {
            builder.setNoParent();
        } else if (this.parentSpan != null) {
            builder.setParent(this.parentSpan.getSpan());
            SpanContextShim contextShim = this.spanContextTable().get(this.parentSpan);
            distContext = contextShim == null ? null : contextShim.getCorrelationContext();
        } else if (this.parentSpanContext != null) {
            builder.setParent(this.parentSpanContext.getSpanContext());
            distContext = this.parentSpanContext.getCorrelationContext();
        }
        for (SpanContext link : this.parentLinks) {
            builder.addLink(link);
        }
        if (this.spanKind != null) {
            builder.setSpanKind(this.spanKind);
        }
        io.opentelemetry.trace.Span span = builder.startSpan();
        for (int i = 0; i < this.spanBuilderAttributeKeys.size(); ++i) {
            String key = this.spanBuilderAttributeKeys.get(i);
            AttributeValue value = this.spanBuilderAttributeValues.get(i);
            span.setAttribute(key, value);
        }
        if (this.error) {
            span.setStatus(Status.UNKNOWN);
        }
        SpanShim spanShim = new SpanShim(this.telemetryInfo(), span);
        if (distContext != null && distContext != this.telemetryInfo().emptyCorrelationContext()) {
            this.spanContextTable().create(spanShim, distContext);
        }
        return spanShim;
    }

    private static SpanShim getSpanShim(Span span) {
        if (!(span instanceof SpanShim)) {
            throw new IllegalArgumentException("span is not a valid SpanShim object");
        }
        return (SpanShim)span;
    }

    private static SpanContextShim getContextShim(io.opentracing.SpanContext context) {
        if (!(context instanceof SpanContextShim)) {
            throw new IllegalArgumentException("context is not a valid SpanContextShim object");
        }
        return (SpanContextShim)context;
    }
}

