/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.Entry;
import io.opentelemetry.correlationcontext.EntryKey;
import io.opentelemetry.correlationcontext.EntryMetadata;
import io.opentelemetry.correlationcontext.EntryValue;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentelemetry.trace.SpanContext;
import java.util.Iterator;
import java.util.Map;

final class SpanContextShim
extends BaseShimObject
implements io.opentracing.SpanContext {
    static final EntryMetadata DEFAULT_ENTRY_METADATA = EntryMetadata.create((EntryMetadata.EntryTtl)EntryMetadata.EntryTtl.UNLIMITED_PROPAGATION);
    private final SpanContext context;
    private final CorrelationContext distContext;

    public SpanContextShim(SpanShim spanShim) {
        this(spanShim.telemetryInfo(), spanShim.getSpan().getContext(), spanShim.telemetryInfo().emptyCorrelationContext());
    }

    public SpanContextShim(TelemetryInfo telemetryInfo, SpanContext context) {
        this(telemetryInfo, context, telemetryInfo.emptyCorrelationContext());
    }

    public SpanContextShim(TelemetryInfo telemetryInfo, SpanContext context, CorrelationContext distContext) {
        super(telemetryInfo);
        this.context = context;
        this.distContext = distContext;
    }

    SpanContextShim newWithKeyValue(String key, String value) {
        CorrelationContext.Builder builder = this.contextManager().contextBuilder().setParent(this.distContext);
        builder.put(EntryKey.create((String)key), EntryValue.create((String)value), DEFAULT_ENTRY_METADATA);
        return new SpanContextShim(this.telemetryInfo(), this.context, builder.build());
    }

    SpanContext getSpanContext() {
        return this.context;
    }

    CorrelationContext getCorrelationContext() {
        return this.distContext;
    }

    public String toTraceId() {
        return this.context.getTraceId().toString();
    }

    public String toSpanId() {
        return this.context.getSpanId().toString();
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        Iterator<Entry> iterator = this.distContext.getEntries().iterator();
        return new BaggageIterable(iterator);
    }

    String getBaggageItem(String key) {
        EntryValue value = this.distContext.getEntryValue(EntryKey.create((String)key));
        return value == null ? null : value.asString();
    }

    static class BaggageEntry
    implements Map.Entry<String, String> {
        final Entry entry;

        BaggageEntry(Entry entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey().getName();
        }

        @Override
        public String getValue() {
            return this.entry.getValue().asString();
        }

        @Override
        public String setValue(String value) {
            return this.getValue();
        }
    }

    static class BaggageIterable
    implements Iterable<Map.Entry<String, String>> {
        final Iterator<Entry> iterator;

        BaggageIterable(Iterator<Entry> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){

                @Override
                public boolean hasNext() {
                    return BaggageIterable.this.iterator.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return new BaggageEntry(BaggageIterable.this.iterator.next());
                }
            };
        }
    }
}

