/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentelemetry.trace.Status;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class SpanShim
extends BaseShimObject
implements Span {
    private static final String DEFAULT_EVENT_NAME = "log";
    private final io.opentelemetry.trace.Span span;

    public SpanShim(TelemetryInfo telemetryInfo, io.opentelemetry.trace.Span span) {
        super(telemetryInfo);
        this.span = span;
    }

    io.opentelemetry.trace.Span getSpan() {
        return this.span;
    }

    public SpanContext context() {
        SpanContextShim contextShim = this.spanContextTable().get(this);
        if (contextShim == null) {
            contextShim = this.spanContextTable().create(this);
        }
        return contextShim;
    }

    public Span setTag(String key, String value) {
        if (!Tags.SPAN_KIND.getKey().equals(key)) {
            if (Tags.ERROR.getKey().equals(key)) {
                Status status = Boolean.parseBoolean(value) ? Status.UNKNOWN : Status.OK;
                this.span.setStatus(status);
            } else {
                this.span.setAttribute(key, value);
            }
        }
        return this;
    }

    public Span setTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key)) {
            Status status = value ? Status.UNKNOWN : Status.OK;
            this.span.setStatus(status);
        } else {
            this.span.setAttribute(key, value);
        }
        return this;
    }

    public Span setTag(String key, Number value) {
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            this.span.setAttribute(key, value.longValue());
        } else if (value instanceof Float || value instanceof Double) {
            this.span.setAttribute(key, value.doubleValue());
        } else {
            throw new IllegalArgumentException("Number type not supported");
        }
        return this;
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        tag.set((Span)this, value);
        return this;
    }

    public Span log(Map<String, ?> fields) {
        this.span.addEvent(SpanShim.getEventNameFromFields(fields), SpanShim.convertToAttributes(fields));
        return this;
    }

    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        this.span.addEvent(SpanShim.getEventNameFromFields(fields), SpanShim.convertToAttributes(fields));
        return this;
    }

    public Span log(String event) {
        this.span.addEvent(event);
        return this;
    }

    public Span log(long timestampMicroseconds, String event) {
        this.span.addEvent(event);
        return this;
    }

    public Span setBaggageItem(String key, String value) {
        if (key == null || value == null) {
            return this;
        }
        this.spanContextTable().setBaggageItem(this, key, value);
        return this;
    }

    @Nullable
    public String getBaggageItem(String key) {
        if (key == null) {
            return null;
        }
        return this.spanContextTable().getBaggageItem(this, key);
    }

    public Span setOperationName(String operationName) {
        this.span.updateName(operationName);
        return this;
    }

    public void finish() {
        this.span.end();
    }

    public void finish(long finishMicros) {
        throw new UnsupportedOperationException();
    }

    static String getEventNameFromFields(Map<String, ?> fields) {
        Object eventValue;
        Object object = eventValue = fields == null ? null : (Object)fields.get("event");
        if (eventValue != null) {
            return eventValue.toString();
        }
        return DEFAULT_EVENT_NAME;
    }

    static Map<String, AttributeValue> convertToAttributes(Map<String, ?> fields) {
        HashMap<String, AttributeValue> attrMap = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                attrMap.put(key, AttributeValue.longAttributeValue((long)((Number)value).longValue()));
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                attrMap.put(key, AttributeValue.doubleAttributeValue((double)((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof Boolean) {
                attrMap.put(key, AttributeValue.booleanAttributeValue((boolean)((Boolean)value)));
                continue;
            }
            attrMap.put(key, AttributeValue.stringAttributeValue((String)value.toString()));
        }
        return attrMap;
    }
}

