/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.CorrelationContextManager;
import io.opentelemetry.opentracingshim.SpanContextShimTable;
import io.opentelemetry.trace.Tracer;

final class TelemetryInfo {
    private final Tracer tracer;
    private final CorrelationContextManager contextManager;
    private final CorrelationContext emptyCorrelationContext;
    private final ContextPropagators propagators;
    private final SpanContextShimTable spanContextTable;

    TelemetryInfo(Tracer tracer, CorrelationContextManager contextManager, ContextPropagators propagators) {
        this.tracer = tracer;
        this.contextManager = contextManager;
        this.propagators = propagators;
        this.emptyCorrelationContext = contextManager.contextBuilder().build();
        this.spanContextTable = new SpanContextShimTable();
    }

    Tracer tracer() {
        return this.tracer;
    }

    CorrelationContextManager contextManager() {
        return this.contextManager;
    }

    SpanContextShimTable spanContextTable() {
        return this.spanContextTable;
    }

    CorrelationContext emptyCorrelationContext() {
        return this.emptyCorrelationContext;
    }

    ContextPropagators propagators() {
        return this.propagators;
    }
}

