/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import io.opentelemetry.sdk.extension.zpages.LatencyBoundary;
import io.opentelemetry.sdk.extension.zpages.TracezSpanBuckets;
import io.opentelemetry.sdk.extension.zpages.TracezSpanProcessor;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TracezDataAggregator {
    private final TracezSpanProcessor spanProcessor;

    TracezDataAggregator(TracezSpanProcessor spanProcessor) {
        this.spanProcessor = spanProcessor;
    }

    Set<String> getSpanNames() {
        TreeSet<String> spanNames = new TreeSet<String>();
        Collection<ReadableSpan> allRunningSpans = this.spanProcessor.getRunningSpans();
        for (ReadableSpan span : allRunningSpans) {
            spanNames.add(span.getName());
        }
        spanNames.addAll(this.spanProcessor.getCompletedSpanCache().keySet());
        return spanNames;
    }

    Map<String, Integer> getRunningSpanCounts() {
        Collection<ReadableSpan> allRunningSpans = this.spanProcessor.getRunningSpans();
        HashMap<String, Integer> numSpansPerName = new HashMap<String, Integer>();
        for (ReadableSpan span : allRunningSpans) {
            Integer prevValue = (Integer)numSpansPerName.get(span.getName());
            numSpansPerName.put(span.getName(), prevValue != null ? prevValue + 1 : 1);
        }
        return numSpansPerName;
    }

    List<SpanData> getRunningSpans(String spanName) {
        Collection<ReadableSpan> allRunningSpans = this.spanProcessor.getRunningSpans();
        ArrayList<SpanData> filteredSpans = new ArrayList<SpanData>();
        for (ReadableSpan span : allRunningSpans) {
            if (!span.getName().equals(spanName)) continue;
            filteredSpans.add(span.toSpanData());
        }
        return filteredSpans;
    }

    Map<String, Map<LatencyBoundary, Integer>> getSpanLatencyCounts() {
        Map<String, TracezSpanBuckets> completedSpanCache = this.spanProcessor.getCompletedSpanCache();
        HashMap<String, Map<LatencyBoundary, Integer>> numSpansPerName = new HashMap<String, Map<LatencyBoundary, Integer>>();
        for (Map.Entry<String, TracezSpanBuckets> cacheEntry : completedSpanCache.entrySet()) {
            numSpansPerName.put(cacheEntry.getKey(), cacheEntry.getValue().getLatencyBoundaryToCountMap());
        }
        return numSpansPerName;
    }

    List<SpanData> getOkSpans(String spanName, long lowerBound, long upperBound) {
        Map<String, TracezSpanBuckets> completedSpanCache = this.spanProcessor.getCompletedSpanCache();
        TracezSpanBuckets buckets = completedSpanCache.get(spanName);
        if (buckets == null) {
            return Collections.emptyList();
        }
        List<ReadableSpan> allOkSpans = buckets.getOkSpans();
        ArrayList<SpanData> filteredSpans = new ArrayList<SpanData>();
        for (ReadableSpan span : allOkSpans) {
            if (span.getLatencyNanos() < lowerBound || span.getLatencyNanos() >= upperBound) continue;
            filteredSpans.add(span.toSpanData());
        }
        return Collections.unmodifiableList(filteredSpans);
    }

    Map<String, Integer> getErrorSpanCounts() {
        Map<String, TracezSpanBuckets> completedSpanCache = this.spanProcessor.getCompletedSpanCache();
        HashMap<String, Integer> numErrorsPerName = new HashMap<String, Integer>();
        for (Map.Entry<String, TracezSpanBuckets> cacheEntry : completedSpanCache.entrySet()) {
            numErrorsPerName.put(cacheEntry.getKey(), cacheEntry.getValue().getErrorSpans().size());
        }
        return numErrorsPerName;
    }

    List<SpanData> getErrorSpans(String spanName) {
        Map<String, TracezSpanBuckets> completedSpanCache = this.spanProcessor.getCompletedSpanCache();
        TracezSpanBuckets buckets = completedSpanCache.get(spanName);
        if (buckets == null) {
            return Collections.emptyList();
        }
        List<ReadableSpan> allErrorSpans = buckets.getErrorSpans();
        ArrayList<SpanData> errorSpans = new ArrayList<SpanData>();
        for (ReadableSpan span : allErrorSpans) {
            errorSpans.add(span.toSpanData());
        }
        return Collections.unmodifiableList(errorSpans);
    }
}

