/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.extension.zpages.LatencyBoundary;
import io.opentelemetry.sdk.extension.zpages.SpanBucket;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

final class TracezSpanBuckets {
    private final ImmutableMap<LatencyBoundary, SpanBucket> latencyBuckets;
    private final ImmutableMap<StatusCode, SpanBucket> errorBuckets;

    TracezSpanBuckets() {
        ImmutableMap.Builder latencyBucketsBuilder = ImmutableMap.builder();
        for (LatencyBoundary bucket : LatencyBoundary.values()) {
            latencyBucketsBuilder.put((Object)bucket, (Object)new SpanBucket(true));
        }
        this.latencyBuckets = latencyBucketsBuilder.build();
        ImmutableMap.Builder errorBucketsBuilder = ImmutableMap.builder();
        for (StatusCode code : StatusCode.values()) {
            if (code != StatusCode.ERROR) continue;
            errorBucketsBuilder.put((Object)code, (Object)new SpanBucket(false));
        }
        this.errorBuckets = errorBucketsBuilder.build();
    }

    void addToBucket(ReadableSpan span) {
        SpanData.Status status = span.toSpanData().getStatus();
        if (status.isOk()) {
            ((SpanBucket)this.latencyBuckets.get((Object)LatencyBoundary.getBoundary(span.getLatencyNanos()))).add(span);
            return;
        }
        ((SpanBucket)this.errorBuckets.get((Object)status.getCanonicalCode())).add(span);
    }

    Map<LatencyBoundary, Integer> getLatencyBoundaryToCountMap() {
        EnumMap<LatencyBoundary, Integer> latencyCounts = new EnumMap<LatencyBoundary, Integer>(LatencyBoundary.class);
        for (LatencyBoundary bucket : LatencyBoundary.values()) {
            latencyCounts.put(bucket, ((SpanBucket)this.latencyBuckets.get((Object)bucket)).size());
        }
        return latencyCounts;
    }

    List<ReadableSpan> getOkSpans() {
        ArrayList<ReadableSpan> okSpans = new ArrayList<ReadableSpan>();
        for (SpanBucket latencyBucket : this.latencyBuckets.values()) {
            latencyBucket.addTo(okSpans);
        }
        return okSpans;
    }

    List<ReadableSpan> getErrorSpans() {
        ArrayList<ReadableSpan> errorSpans = new ArrayList<ReadableSpan>();
        for (SpanBucket errorBucket : this.errorBuckets.values()) {
            errorBucket.addTo(errorSpans);
        }
        return errorSpans;
    }

    List<ReadableSpan> getSpans() {
        ArrayList<ReadableSpan> spans = new ArrayList<ReadableSpan>();
        spans.addAll(this.getOkSpans());
        spans.addAll(this.getErrorSpans());
        return spans;
    }
}

