/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.UrlEscapers;
import io.opentelemetry.api.common.AttributeConsumer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.ReadableAttributes;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.extension.zpages.LatencyBoundary;
import io.opentelemetry.sdk.extension.zpages.TracezDataAggregator;
import io.opentelemetry.sdk.extension.zpages.ZPageHandler;
import io.opentelemetry.sdk.extension.zpages.ZPageLogo;
import io.opentelemetry.sdk.extension.zpages.ZPageStyle;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class TracezZPageHandler
extends ZPageHandler {
    private static final String TRACEZ_URL = "/tracez";
    private static final String TRACEZ_NAME = "TraceZ";
    private static final String TRACEZ_DESCRIPTION = "TraceZ displays information about all the running spans and all the sampled spans based on latency and errors";
    private static final String ZEBRA_STRIPE_COLOR = "#e6e6e6";
    private static final String SAMPLED_TRACE_ID_COLOR = "#c1272d";
    private static final String NOT_SAMPLED_TRACE_ID_COLOR = "black";
    private static final String PARAM_SPAN_NAME = "zspanname";
    private static final String PARAM_SAMPLE_TYPE = "ztype";
    private static final String PARAM_SAMPLE_SUB_TYPE = "zsubtype";
    private static final ImmutableMap<LatencyBoundary, String> LATENCY_BOUNDARIES_STRING_MAP = TracezZPageHandler.buildLatencyBoundaryStringMap();
    private static final Logger logger = Logger.getLogger(TracezZPageHandler.class.getName());
    @Nullable
    private final TracezDataAggregator dataAggregator;

    TracezZPageHandler(@Nullable TracezDataAggregator dataAggregator) {
        this.dataAggregator = dataAggregator;
    }

    @Override
    public String getUrlPath() {
        return TRACEZ_URL;
    }

    @Override
    public String getPageName() {
        return TRACEZ_NAME;
    }

    @Override
    public String getPageDescription() {
        return TRACEZ_DESCRIPTION;
    }

    private static void emitHtmlStyle(PrintStream out) {
        out.print("<style>");
        out.print(ZPageStyle.style);
        out.print("</style>");
    }

    private static void emitSummaryTableHeader(PrintStream out) {
        out.print("<tr class=\"bg-color\">");
        out.print("<th colspan=1 class=\"header-text\"><b>Span Name</b></th>");
        out.print("<th colspan=1 class=\"header-text border-left-white\"><b>Running</b></th>");
        out.print("<th colspan=9 class=\"header-text border-left-white\"><b>Latency Samples</b></th>");
        out.print("<th colspan=1 class=\"header-text border-left-white\"><b>Error Samples</b></th>");
        out.print("</tr>");
        out.print("<tr class=\"bg-color\">");
        out.print("<th colspan=1></th>");
        out.print("<th colspan=1 class=\"border-left-white\"></th>");
        for (LatencyBoundary latencyBoundary : LatencyBoundary.values()) {
            out.print("<th colspan=1 class=\"border-left-white align-center\"style=\"color: #fff;\"><b>[" + (String)LATENCY_BOUNDARIES_STRING_MAP.get((Object)latencyBoundary) + "]</b></th>");
        }
        out.print("<th colspan=1 class=\"border-left-white\"></th>");
        out.print("</tr>");
    }

    private static void emitSummaryTableCell(PrintStream out, String spanName, int numOfSamples, SampleType type, int subtype) {
        if (numOfSamples > 0) {
            out.print("<td class=\"align-center border-left-dark\"><a href=\"?");
            out.print("zspanname=" + UrlEscapers.urlFormParameterEscaper().escape(spanName));
            out.print("&ztype=" + type.getValue());
            out.print("&zsubtype=" + subtype);
            out.print("\">" + numOfSamples + "</a></td>");
        } else if (numOfSamples < 0) {
            out.print("<td class=\"align-center border-left-dark\">N/A</td>");
        } else {
            out.print("<td class=\"align-center border-left-dark\">0</td>");
        }
    }

    private void emitSummaryTable(PrintStream out) {
        if (this.dataAggregator == null) {
            return;
        }
        out.print("<table style=\"border-spacing: 0; border: 1px solid #363636;\">");
        TracezZPageHandler.emitSummaryTableHeader(out);
        Set<String> spanNames = this.dataAggregator.getSpanNames();
        boolean zebraStripe = false;
        Map<String, Integer> runningSpanCounts = this.dataAggregator.getRunningSpanCounts();
        Map<String, Map<LatencyBoundary, Integer>> latencySpanCounts = this.dataAggregator.getSpanLatencyCounts();
        Map<String, Integer> errorSpanCounts = this.dataAggregator.getErrorSpanCounts();
        for (String spanName : spanNames) {
            if (zebraStripe) {
                out.print("<tr style=\"background-color: #e6e6e6\">");
            } else {
                out.print("<tr>");
            }
            zebraStripe = !zebraStripe;
            out.print("<td>" + HtmlEscapers.htmlEscaper().escape(spanName) + "</td>");
            int numOfRunningSpans = runningSpanCounts.containsKey(spanName) ? runningSpanCounts.get(spanName) : 0;
            TracezZPageHandler.emitSummaryTableCell(out, spanName, numOfRunningSpans, SampleType.RUNNING, 0);
            int subtype = 0;
            for (LatencyBoundary latencyBoundary : LatencyBoundary.values()) {
                int numOfLatencySamples = latencySpanCounts.containsKey(spanName) && latencySpanCounts.get(spanName).containsKey((Object)latencyBoundary) ? latencySpanCounts.get(spanName).get((Object)latencyBoundary) : 0;
                TracezZPageHandler.emitSummaryTableCell(out, spanName, numOfLatencySamples, SampleType.LATENCY, subtype);
                ++subtype;
            }
            int numOfErrorSamples = errorSpanCounts.containsKey(spanName) ? errorSpanCounts.get(spanName) : 0;
            TracezZPageHandler.emitSummaryTableCell(out, spanName, numOfErrorSamples, SampleType.ERROR, 0);
        }
        out.print("</table>");
    }

    private static void emitSpanNameAndCount(PrintStream out, String spanName, int count, SampleType type) {
        out.print("<p class=\"align-center\"><b> Span Name: " + HtmlEscapers.htmlEscaper().escape(spanName) + "</b></p>");
        String typeString = type == SampleType.RUNNING ? "running" : (type == SampleType.LATENCY ? "latency samples" : "error samples");
        out.print("<p class=\"align-center\"><b> Number of " + typeString + ": " + count + "</b></p>");
    }

    private static void emitSpanDetails(PrintStream out, Formatter formatter, Collection<SpanData> spans) {
        out.print("<table style=\"border-spacing: 0; border: 1px solid #363636;\">");
        out.print("<tr class=\"bg-color\">");
        out.print("<td style=\"color: #fff;\"><pre class=\"no-margin wrap-text\"><b>When</b></pre></td>");
        out.print("<td class=\"border-left-white\" style=\"color: #fff;\"><pre class=\"no-margin wrap-text\"><b>Elapsed(s)</b></pre></td>");
        out.print("<td class=\"border-left-white\"></td>");
        out.print("</tr>");
        boolean zebraStripe = false;
        for (SpanData span : spans) {
            zebraStripe = TracezZPageHandler.emitSingleSpan(out, formatter, span, zebraStripe);
        }
        out.print("</table>");
    }

    private static boolean emitSingleSpan(PrintStream out, Formatter formatter, SpanData span, boolean zebraStripe) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUnit.NANOSECONDS.toMillis(span.getStartEpochNanos()));
        long microsField = TimeUnit.NANOSECONDS.toMicros(span.getStartEpochNanos());
        String elapsedSecondsStr = span.hasEnded() ? String.format("%.6f", (double)(span.getEndEpochNanos() - span.getStartEpochNanos()) * 1.0E-9) : "";
        formatter.format("<tr style=\"background-color: %s;\">", zebraStripe ? ZEBRA_STRIPE_COLOR : "#fff");
        formatter.format("<td class=\"align-right\"><pre class=\"no-margin wrap-text\"><b>%04d/%02d/%02d-%02d:%02d:%02d.%06d</b></pre></td>", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), microsField);
        formatter.format("<td class=\"border-left-dark\"><pre class=\"no-margin wrap-text\"><b>%s</b></pre></td>", elapsedSecondsStr);
        formatter.format("<td class=\"border-left-dark\"><pre class=\"no-margin wrap-text\"><b>TraceId: <b style=\"color:%s;\">%s</b>  | SpanId: %s | ParentSpanId: %s</b></pre></td>", span.isSampled() ? SAMPLED_TRACE_ID_COLOR : NOT_SAMPLED_TRACE_ID_COLOR, span.getTraceId(), span.getSpanId(), span.getParentSpanId() == null ? SpanId.getInvalid() : span.getParentSpanId());
        out.print("</tr>");
        zebraStripe = !zebraStripe;
        int lastEntryDayOfYear = calendar.get(6);
        long lastEpochNanos = span.getStartEpochNanos();
        ArrayList timedEvents = new ArrayList(span.getEvents());
        Collections.sort(timedEvents, new EventComparator());
        for (SpanData.Event event : timedEvents) {
            calendar.setTimeInMillis(TimeUnit.NANOSECONDS.toMillis(event.getEpochNanos()));
            formatter.format("<tr style=\"background-color: %s;\">", zebraStripe ? ZEBRA_STRIPE_COLOR : "#fff");
            TracezZPageHandler.emitSingleEvent(out, formatter, event, calendar, lastEntryDayOfYear, lastEpochNanos);
            out.print("</tr>");
            if (calendar.get(6) != lastEntryDayOfYear) {
                lastEntryDayOfYear = calendar.get(6);
            }
            lastEpochNanos = event.getEpochNanos();
            zebraStripe = !zebraStripe;
        }
        formatter.format("<tr style=\"background-color: %s;\"><td></td><td class=\"border-left-dark\"></td><td class=\"border-left-dark\"><pre class=\"no-margin wrap-text\">", zebraStripe ? ZEBRA_STRIPE_COLOR : "#fff");
        SpanData.Status status = span.getStatus();
        if (status != null) {
            formatter.format("%s | ", HtmlEscapers.htmlEscaper().escape(status.toString()));
        }
        formatter.format("%s</pre></td>", HtmlEscapers.htmlEscaper().escape(TracezZPageHandler.renderAttributes(span.getAttributes())));
        zebraStripe = !zebraStripe;
        return zebraStripe;
    }

    private static void emitSingleEvent(PrintStream out, Formatter formatter, SpanData.Event event, Calendar calendar, int lastEntryDayOfYear, long lastEpochNanos) {
        if (calendar.get(6) == lastEntryDayOfYear) {
            out.print("<td class=\"align-right\"><pre class=\"no-margin wrap-text\">");
        } else {
            formatter.format("<td class=\"align-right\"><pre class=\"no-margin wrap-text\">%04d/%02d/%02d-", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        }
        long deltaMicros = TimeUnit.NANOSECONDS.toMicros(event.getEpochNanos() - lastEpochNanos);
        String deltaString = deltaMicros >= 1000000L ? String.format("%.6f", (double)deltaMicros / 1000000.0) : String.format("%1s.%6d", "", deltaMicros);
        long microsField = TimeUnit.NANOSECONDS.toMicros(event.getEpochNanos());
        formatter.format("%02d:%02d:%02d.%06d</pre></td> <td class=\"border-left-dark\"><pre class=\"no-margin wrap-text\">%s</pre></td><td class=\"border-left-dark\"><pre class=\"no-margin wrap-text\">%s</pre></td>", calendar.get(11), calendar.get(12), calendar.get(13), microsField, deltaString, HtmlEscapers.htmlEscaper().escape(TracezZPageHandler.renderEvent(event)));
    }

    private static String renderAttributes(ReadableAttributes attributes) {
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attributes:{");
        attributes.forEach(new AttributeConsumer(){
            private boolean first = true;

            public <T> void accept(AttributeKey<T> key, T value) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(key);
                stringBuilder.append("=");
                stringBuilder.append(value.toString());
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String renderEvent(SpanData.Event event) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(event.getName());
        if (!event.getAttributes().isEmpty()) {
            stringBuilder.append(" | ");
            stringBuilder.append(TracezZPageHandler.renderAttributes((ReadableAttributes)event.getAttributes()));
        }
        return stringBuilder.toString();
    }

    private void emitHtmlBody(Map<String, String> queryMap, PrintStream out) {
        String typeStr;
        if (this.dataAggregator == null) {
            out.print("OpenTelemetry implementation not available.");
            return;
        }
        out.print("<a href=\"/\"><img style=\"height: 90px;\" src=\"data:image/png;base64," + ZPageLogo.getLogoBase64() + "\" /></a>");
        out.print("<h1>TraceZ Summary</h1>");
        this.emitSummaryTable(out);
        String spanName = queryMap.get(PARAM_SPAN_NAME);
        if (spanName != null && (typeStr = queryMap.get(PARAM_SAMPLE_TYPE)) != null) {
            ImmutableList spans = null;
            SampleType type = SampleType.fromString(typeStr);
            if (type == SampleType.UNKNOWN) {
                return;
            }
            if (type == SampleType.RUNNING) {
                spans = this.dataAggregator.getRunningSpans(spanName);
            } else {
                String subtypeStr = queryMap.get(PARAM_SAMPLE_SUB_TYPE);
                if (subtypeStr != null) {
                    int subtype = Integer.parseInt(subtypeStr);
                    if (type == SampleType.LATENCY) {
                        if (subtype < 0 || subtype >= LatencyBoundary.values().length) {
                            return;
                        }
                        LatencyBoundary latencyBoundary = LatencyBoundary.values()[subtype];
                        spans = this.dataAggregator.getOkSpans(spanName, latencyBoundary.getLatencyLowerBound(), latencyBoundary.getLatencyUpperBound());
                    } else {
                        if (subtype < 0 || subtype >= StatusCode.values().length) {
                            return;
                        }
                        spans = this.dataAggregator.getErrorSpans(spanName);
                    }
                }
            }
            out.print("<h2>Span Details</h2>");
            TracezZPageHandler.emitSpanNameAndCount(out, spanName, spans == null ? 0 : spans.size(), type);
            if (spans != null) {
                Formatter formatter = new Formatter(out, Locale.US);
                spans = ImmutableList.sortedCopyOf((Comparator)new SpanDataComparator(true), spans);
                TracezZPageHandler.emitSpanDetails(out, formatter, (Collection<SpanData>)spans);
            }
        }
    }

    @Override
    public void emitHtml(Map<String, String> queryMap, OutputStream outputStream) {
        try (PrintStream out = new PrintStream(outputStream, false, "UTF-8");){
            out.print("<!DOCTYPE html>");
            out.print("<html lang=\"en\">");
            out.print("<head>");
            out.print("<meta charset=\"UTF-8\">");
            out.print("<link rel=\"shortcut icon\" href=\"data:image/png;base64," + ZPageLogo.getFaviconBase64() + "\" type=\"image/png\">");
            out.print("<link href=\"https://fonts.googleapis.com/css?family=Open+Sans:300\"rel=\"stylesheet\">");
            out.print("<link href=\"https://fonts.googleapis.com/css?family=Roboto\" rel=\"stylesheet\">");
            out.print("<title>TraceZ</title>");
            TracezZPageHandler.emitHtmlStyle(out);
            out.print("</head>");
            out.print("<body>");
            try {
                this.emitHtmlBody(queryMap, out);
            }
            catch (Throwable t) {
                out.print("Error while generating HTML: " + t.toString());
                logger.log(Level.WARNING, "error while generating HTML", t);
            }
            out.print("</body>");
            out.print("</html>");
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "error while generating HTML", t);
        }
    }

    private static String latencyBoundaryToString(LatencyBoundary latencyBoundary) {
        switch (latencyBoundary) {
            case ZERO_MICROSx10: {
                return ">0us";
            }
            case MICROSx10_MICROSx100: {
                return ">10us";
            }
            case MICROSx100_MILLIx1: {
                return ">100us";
            }
            case MILLIx1_MILLIx10: {
                return ">1ms";
            }
            case MILLIx10_MILLIx100: {
                return ">10ms";
            }
            case MILLIx100_SECONDx1: {
                return ">100ms";
            }
            case SECONDx1_SECONDx10: {
                return ">1s";
            }
            case SECONDx10_SECONDx100: {
                return ">10s";
            }
            case SECONDx100_MAX: {
                return ">100s";
            }
        }
        throw new IllegalArgumentException("No value string available for: " + (Object)((Object)latencyBoundary));
    }

    private static ImmutableMap<LatencyBoundary, String> buildLatencyBoundaryStringMap() {
        HashMap<LatencyBoundary, String> latencyBoundaryMap = new HashMap<LatencyBoundary, String>();
        for (LatencyBoundary latencyBoundary : LatencyBoundary.values()) {
            latencyBoundaryMap.put(latencyBoundary, TracezZPageHandler.latencyBoundaryToString(latencyBoundary));
        }
        return ImmutableMap.copyOf(latencyBoundaryMap);
    }

    private static final class SpanDataComparator
    implements Comparator<SpanData>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean incremental;

        private SpanDataComparator(boolean incremental) {
            this.incremental = incremental;
        }

        @Override
        public int compare(SpanData s1, SpanData s2) {
            return this.incremental ? Long.compare(s1.getStartEpochNanos(), s2.getStartEpochNanos()) : Long.compare(s2.getStartEpochNanos(), s1.getEndEpochNanos());
        }
    }

    private static final class EventComparator
    implements Comparator<SpanData.Event>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private EventComparator() {
        }

        @Override
        public int compare(SpanData.Event e1, SpanData.Event e2) {
            return Long.compare(e1.getEpochNanos(), e2.getEpochNanos());
        }
    }

    private static enum SampleType {
        RUNNING(0),
        LATENCY(1),
        ERROR(2),
        UNKNOWN(-1);

        private final int value;

        private SampleType(int value) {
            this.value = value;
        }

        static SampleType fromString(String str) {
            int value = Integer.parseInt(str);
            switch (value) {
                case 0: {
                    return RUNNING;
                }
                case 1: {
                    return LATENCY;
                }
                case 2: {
                    return ERROR;
                }
            }
            return UNKNOWN;
        }

        int getValue() {
            return this.value;
        }
    }
}

