/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.opentelemetry.sdk.extension.zpages.ZPageHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ZPageHttpHandler
implements HttpHandler {
    private static final Splitter QUERY_SPLITTER = Splitter.on((String)"&").trimResults().omitEmptyStrings();
    private static final Splitter QUERY_KEYVAL_SPLITTER = Splitter.on((String)"=").trimResults().omitEmptyStrings();
    private static final String PARAM_SPAN_NAME = "zspanname";
    private final ZPageHandler zpageHandler;

    ZPageHttpHandler(ZPageHandler zpageHandler) {
        this.zpageHandler = zpageHandler;
    }

    @VisibleForTesting
    static ImmutableMap<String, String> parseQueryString(String queryString) throws UnsupportedEncodingException {
        if (queryString == null) {
            return ImmutableMap.of();
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        for (String param : QUERY_SPLITTER.split((CharSequence)queryString)) {
            List keyValuePair = QUERY_KEYVAL_SPLITTER.splitToList((CharSequence)param);
            if (keyValuePair.size() <= 1) continue;
            if (((String)keyValuePair.get(0)).equals(PARAM_SPAN_NAME)) {
                queryMap.put((String)keyValuePair.get(0), URLDecoder.decode((String)keyValuePair.get(1), "UTF-8"));
                continue;
            }
            queryMap.put((String)keyValuePair.get(0), (String)keyValuePair.get(1));
        }
        return ImmutableMap.copyOf(queryMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(HttpExchange httpExchange) throws IOException {
        block10: {
            try {
                String queryString;
                String requestMethod = httpExchange.getRequestMethod();
                httpExchange.sendResponseHeaders(200, 0L);
                if (requestMethod.equalsIgnoreCase("GET")) {
                    this.zpageHandler.emitHtml((Map<String, String>)ZPageHttpHandler.parseQueryString(httpExchange.getRequestURI().getRawQuery()), httpExchange.getResponseBody());
                    break block10;
                }
                try (InputStreamReader requestBodyReader = new InputStreamReader(httpExchange.getRequestBody(), "utf-8");){
                    queryString = CharStreams.toString((Readable)requestBodyReader);
                }
                boolean error = this.zpageHandler.processRequest(requestMethod, (Map<String, String>)ZPageHttpHandler.parseQueryString(queryString), httpExchange.getResponseBody());
                if (!error) {
                    this.zpageHandler.emitHtml((Map<String, String>)ZPageHttpHandler.parseQueryString(queryString), httpExchange.getResponseBody());
                }
            }
            finally {
                httpExchange.close();
            }
        }
    }
}

