/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.zpages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sun.net.httpserver.HttpServer;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.extension.zpages.IndexZPageHandler;
import io.opentelemetry.sdk.extension.zpages.TraceConfigzZPageHandler;
import io.opentelemetry.sdk.extension.zpages.TracezDataAggregator;
import io.opentelemetry.sdk.extension.zpages.TracezSpanProcessor;
import io.opentelemetry.sdk.extension.zpages.TracezZPageHandler;
import io.opentelemetry.sdk.extension.zpages.ZPageHandler;
import io.opentelemetry.sdk.extension.zpages.ZPageHttpHandler;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdkManagement;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ZPageServer {
    private static final int HTTPSERVER_BACKLOG = 5;
    private static final int HTTPSERVER_STOP_DELAY = 1;
    private static final TracezSpanProcessor tracezSpanProcessor = TracezSpanProcessor.builder().build();
    private static final TracezDataAggregator tracezDataAggregator = new TracezDataAggregator(tracezSpanProcessor);
    private static final TracerSdkManagement TRACER_SDK_MANAGEMENT = OpenTelemetrySdk.getGlobalTracerManagement();
    private static final ZPageHandler tracezZPageHandler = new TracezZPageHandler(tracezDataAggregator);
    private static final ZPageHandler traceConfigzZPageHandler = new TraceConfigzZPageHandler(TRACER_SDK_MANAGEMENT);
    private static final ZPageHandler indexZPageHandler = new IndexZPageHandler((List<ZPageHandler>)ImmutableList.of((Object)tracezZPageHandler, (Object)traceConfigzZPageHandler));
    private static final Object mutex = new Object();
    private static final AtomicBoolean isTracezSpanProcesserAdded = new AtomicBoolean(false);
    @Nullable
    @GuardedBy(value="mutex")
    private static HttpServer server;

    private static void addTracezSpanProcessor() {
        if (isTracezSpanProcesserAdded.compareAndSet(false, true)) {
            TRACER_SDK_MANAGEMENT.addSpanProcessor((SpanProcessor)tracezSpanProcessor);
        }
    }

    static void registerIndexZPageHandler(HttpServer server) {
        server.createContext(indexZPageHandler.getUrlPath(), new ZPageHttpHandler(indexZPageHandler));
    }

    static void registerTracezZPageHandler(HttpServer server) {
        ZPageServer.addTracezSpanProcessor();
        server.createContext(tracezZPageHandler.getUrlPath(), new ZPageHttpHandler(tracezZPageHandler));
    }

    static void registerTraceConfigzZPageHandler(HttpServer server) {
        server.createContext(traceConfigzZPageHandler.getUrlPath(), new ZPageHttpHandler(traceConfigzZPageHandler));
    }

    public static void registerAllPagesToHttpServer(HttpServer server) {
        ZPageServer.registerIndexZPageHandler(server);
        ZPageServer.registerTracezZPageHandler(server);
        ZPageServer.registerTraceConfigzZPageHandler(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stop() {
        Object object = mutex;
        synchronized (object) {
            if (server == null) {
                return;
            }
            server.stop(1);
            server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startHttpServerAndRegisterAllPages(int port) throws IOException {
        Object object = mutex;
        synchronized (object) {
            Preconditions.checkState((server == null ? 1 : 0) != 0, (Object)"The HttpServer is already started.");
            server = HttpServer.create(new InetSocketAddress(port), 5);
            ZPageServer.registerAllPagesToHttpServer(server);
            server.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ZPageServer.stop();
            }
        });
    }

    @VisibleForTesting
    static boolean getIsTracezSpanProcesserAdded() {
        return isTracezSpanProcesserAdded.get();
    }

    private ZPageServer() {
    }
}

