/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.elasticsearch7;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.elasticsearch.common.SpanDecorator;
import io.opentracing.contrib.elasticsearch7.TracingResponseListener;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.Collection;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class TracingPreBuiltTransportClient
extends PreBuiltTransportClient {
    private final Tracer tracer;

    @SafeVarargs
    public TracingPreBuiltTransportClient(Tracer tracer, Settings settings, Class<? extends Plugin> ... plugins) {
        super(settings, (Class[])plugins);
        this.tracer = tracer;
    }

    @SafeVarargs
    public TracingPreBuiltTransportClient(Settings settings, Class<? extends Plugin> ... plugins) {
        this(GlobalTracer.get(), settings, plugins);
    }

    public TracingPreBuiltTransportClient(Tracer tracer, Settings settings, Collection<Class<? extends Plugin>> plugins) {
        super(settings, plugins);
        this.tracer = tracer;
    }

    public TracingPreBuiltTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        this(GlobalTracer.get(), settings, plugins);
    }

    public TracingPreBuiltTransportClient(Tracer tracer, Settings settings, Collection<Class<? extends Plugin>> plugins, TransportClient.HostFailureListener hostFailureListener) {
        super(settings, plugins, hostFailureListener);
        this.tracer = tracer;
    }

    public TracingPreBuiltTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins, TransportClient.HostFailureListener hostFailureListener) {
        this(GlobalTracer.get(), settings, plugins, hostFailureListener);
    }

    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(Action<Response> action, Request request, ActionListener<Response> listener) {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(request.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        SpanDecorator.onRequest((Span)span);
        TracingResponseListener<Response> actionFuture = new TracingResponseListener<Response>(listener, span);
        super.doExecute(action, request, actionFuture);
    }
}

