/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.elasticsearch7;

import io.opentracing.Span;
import io.opentracing.contrib.elasticsearch.common.SpanDecorator;
import io.opentracing.tag.Tags;
import java.net.InetSocketAddress;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;

public class TracingResponseListener<T extends ActionResponse>
implements ActionListener<T> {
    private final ActionListener<T> listener;
    private final Span span;

    public TracingResponseListener(ActionListener<T> listener, Span span) {
        this.listener = listener;
        this.span = span;
    }

    public void onResponse(T t) {
        InetSocketAddress address;
        if (t.remoteAddress() != null && (address = t.remoteAddress().address()) != null) {
            Tags.PEER_HOSTNAME.set(this.span, address.getHostName());
            Tags.PEER_PORT.set(this.span, Integer.valueOf(address.getPort()));
        }
        try {
            this.listener.onResponse(t);
        }
        finally {
            this.span.finish();
        }
    }

    public void onFailure(Exception e) {
        SpanDecorator.onError((Throwable)e, (Span)this.span);
        try {
            this.listener.onFailure(e);
        }
        finally {
            this.span.finish();
        }
    }
}

