/*
 * Copyright 2020 Outfox, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.outfoxx.sunday.http

/**
 * Commonly used HTTP header names.
 */
object HeaderNames {

  const val Accept = "accept"
  const val Authorization = "authorization"
  const val Connection = "connection"
  const val ContentLength = "content-length"
  const val ContentType = "content-type"
  const val Location = "location"
  const val Server = "server"
  const val TransferEncoding = "transfer-encoding"
  const val UserAgent = "user-agent"
  const val Cookie = "cookie"
  const val SetCookie = "set-cookie"
  const val Expect = "expect"

  const val LastEventId = "last-event-id"
}
