import {html, LitElement, TemplateResult} from 'lit';
import {ifDefined} from 'lit-html/directives/if-defined';
import {customElement, property} from 'lit/decorators.js';


@customElement('tinymce-field')
export class TinyMceField extends LitElement {
    @property() editorId: string = "";
    @property() label: string = "";
    @property() config: object;
    @property() editorReadOnly: boolean = false;
    @property() content: string = "";

    constructor(editorId: string, config: object, editorReadOnly: boolean, content: string) {
        super();
        this.editorId = editorId;
        this.config = config;
        this.editorReadOnly = editorReadOnly;
        this.content = content;
    }

    render(): TemplateResult {
        return html`
            <vaadin-custom-field style="width: 100%;">
                <label slot="label" class="tinymce-label" id="label-${this.editorId}"
                       for="tinymce-${this.editorId}">${this.label}</label>
                <div style="margin-top: var(--lumo-space-xs)">
                    <tinymce-editor
                            id="tinymce-${this.editorId}"
                            editor-id="${this.editorId}"
                            api-key="${ifDefined(this.config.apiKey ? this.config.apiKey : undefined)}"
                            entity_encoding="${ifDefined(this.config.entityEncoding ? this.config.entityEncoding : undefined)}"
                            setup="${ifDefined(this.config.setup ? this.config.setup : undefined)}"
                            width="${ifDefined(this.config.width ? this.config.width : undefined)}"
                            height="${ifDefined(this.config.height ? this.config.height : undefined)}"
                            toolbar_mode="${ifDefined(this.config.toolbarMode ? this.config.toolbarMode.toLowerCase() : undefined)}"
                            plugins="${ifDefined(this.config.plugins && this.config.plugins.length > 0 ? this.config.plugins.join(" ") : undefined)}"
                            toolbar="${ifDefined(this.config.toolbar && this.config.toolbar.length > 0 ? this.config.toolbar.join(" ") : undefined)}"
                            menubar="${ifDefined(this.config.menubar && this.config.menubar.length > 0 ? this.config.menubar.join(" ") : undefined)}"
                            contextmenu="${ifDefined(this.config.contextMenu && this.config.contextmenu.length > 0 ? this.config.contextMenu.join(" ") : undefined)}"
                            content_css="${ifDefined(this.config.contentCss ? this.config.contentCss : undefined)}"
                            content_style="${ifDefined(this.config.contentStyle ? this.config.contentStyle : undefined)}"
                            powerpaste_word_import="${ifDefined(this.config.getPowerPasteWordImport ? this.config.getPowerPasteWordImport.toLowerCase() : undefined)}"
                            powerpaste_html_import="${ifDefined(this.config.getPowerPasteHtmlImport ? this.config.getPowerPasteHtmlImport.toLowerCase() : undefined)}"
                            powerpaste_allow_local_images="${ifDefined(this.config.getPowerPageAllowLocalImages ? this.config.getPowerPageAllowLocalImages : undefined)}"
                            resize="${ifDefined(this.config.resize ? this.config.resize.toLowerCase() : undefined)}"
                            skin="${ifDefined(this.config.skin ? this.config.skin.toLowerCase() : undefined)}"
                            icon="${ifDefined(this.config.icon ? this.config.icon.toLowerCase() : undefined)}"
                            readonly="${ifDefined(this.editorReadOnly ? '' : undefined)}"
                            on-Change="tinyMceChangeHandler"
                    >
                        ${this.content}
                    </tinymce-editor>
                </div>
            </vaadin-custom-field>
        `;
    }

    createRenderRoot() {
        return this;
    }

    update(changedProperties: Map<string, any>) {
        if (changedProperties.has("editorReadOnly")) {
            let oldValue = changedProperties.get("editorReadOnly") as boolean;
            let newValue = this.editorReadOnly;
            this.getUpdateComplete()
            let editor = this.renderRoot.querySelector("tinymce-editor")
            if (editor != null && editor._editor != null) {
                editor._editor.mode.set(newValue ? "readonly" : "design");
                editor.readonly = newValue
            }
        }
        super.update(changedProperties);
    }


}