/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core;

import io.parallec.core.util.PcDateUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRegex {
    private static Logger logger = LoggerFactory.getLogger(FilterRegex.class);
    private String regex;

    public FilterRegex() {
    }

    public FilterRegex(String regex1) {
        this.setRegex(regex1);
    }

    public String filter(String input) {
        return FilterRegex.stringMatcherByPattern(input, this.regex);
    }

    public static String stringMatcherByPattern(String input, String patternStr) {
        String output = "SYSTEM_FAIL_MATCH_REGEX";
        if (patternStr == null) {
            logger.error("patternStr is NULL! (Expected when the aggregation rule is not defined at " + PcDateUtils.getNowDateTimeStrStandard());
            return output;
        }
        if (input == null) {
            logger.error("input (Expected when the response is null and now try to match on response) is NULL in stringMatcherByPattern() at " + PcDateUtils.getNowDateTimeStrStandard());
            return output;
        }
        input = input.replace("\n", "").replace("\r", "");
        logger.debug("input: " + input);
        logger.debug("patternStr: " + patternStr);
        Pattern patternMetric = Pattern.compile(patternStr, 8);
        Matcher matcher = patternMetric.matcher(input);
        if (matcher.matches()) {
            output = matcher.group(1);
        }
        return output;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

