/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.UntypedActor;
import io.parallec.core.actor.message.ResponseOnSingeRequest;
import io.parallec.core.actor.message.type.RequestWorkerMsgType;
import io.parallec.core.bean.ping.PingMeta;
import io.parallec.core.commander.workflow.ping.PingProvider;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.ActorMessageTypeInvalidException;
import io.parallec.core.resources.TcpUdpSshPingResourceStore;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcErrorMsgUtils;
import io.parallec.core.util.PcStringUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class PingWorker
extends UntypedActor {
    private static Logger logger = LoggerFactory.getLogger(PingWorker.class);
    private int actorMaxOperationTimeoutSec;
    private ActorRef sender = null;
    private Throwable cause;
    private int tryCount = 0;
    private Cancellable timeoutMessageCancellable = null;
    private FiniteDuration timeoutDuration = null;
    private boolean sentReply = false;
    private String targetHost;
    private PingMeta pingMeta;
    private Future<ResponseOnSingeRequest> responseFuture;

    public PingWorker(int actorMaxOperationTimeoutSec, PingMeta pingMeta, String targetHost) {
        this.actorMaxOperationTimeoutSec = actorMaxOperationTimeoutSec;
        this.pingMeta = pingMeta;
        this.targetHost = targetHost;
    }

    public void onReceive(Object message) throws Exception {
        try {
            if (message instanceof RequestWorkerMsgType) {
                switch ((RequestWorkerMsgType)((Object)message)) {
                    case PROCESS_REQUEST: {
                        ++this.tryCount;
                        if (this.tryCount == 1) {
                            this.sender = this.getSender();
                            this.timeoutDuration = Duration.create((long)this.actorMaxOperationTimeoutSec, (TimeUnit)TimeUnit.SECONDS);
                            this.timeoutMessageCancellable = this.getContext().system().scheduler().scheduleOnce(this.timeoutDuration, this.getSelf(), (Object)RequestWorkerMsgType.PROCESS_ON_TIMEOUT, (ExecutionContext)this.getContext().system().dispatcher(), this.getSelf());
                            PingTask pingTask = new PingTask(this.targetHost, this.pingMeta);
                            this.setResponseFuture(TcpUdpSshPingResourceStore.getInstance().getThreadPoolForSshPing().submit(pingTask));
                            this.getContext().system().scheduler().scheduleOnce((FiniteDuration)Duration.create((double)0.5, (TimeUnit)TimeUnit.SECONDS), new Runnable(){

                                @Override
                                public void run() {
                                    PingWorker.this.getSelf().tell((Object)RequestWorkerMsgType.CHECK_FUTURE_STATE, PingWorker.this.getSelf());
                                }
                            }, (ExecutionContext)this.getContext().system().dispatcher());
                            break;
                        }
                        PingWorker.getLogger().error("duplicated PROCESS_REQUEST msg. ignore...");
                        break;
                    }
                    case CHECK_FUTURE_STATE: {
                        PingWorker.getLogger().debug("checking if Ping callable future completed... for " + this.targetHost);
                        if (this.getResponseFuture().isDone()) {
                            PingWorker.getLogger().debug("Ping Provider callable returned. for " + this.targetHost);
                            ResponseOnSingeRequest sshResponse = this.getResponseFuture().get();
                            this.onComplete(sshResponse);
                            break;
                        }
                        this.getContext().system().scheduler().scheduleOnce((FiniteDuration)Duration.create((double)ParallecGlobalConfig.pingFutureCheckIntervalSec, (TimeUnit)TimeUnit.SECONDS), new Runnable(){

                            @Override
                            public void run() {
                                PingWorker.this.getSelf().tell((Object)RequestWorkerMsgType.CHECK_FUTURE_STATE, PingWorker.this.getSelf());
                            }
                        }, (ExecutionContext)this.getContext().system().dispatcher());
                        break;
                    }
                    case CANCEL: {
                        if (this.sender == null) {
                            this.sender = this.getSender();
                        }
                        PingWorker.getLogger().info("Request was CANCELLED.................on SSH host {}", (Object)this.targetHost);
                        this.cancelCancellable();
                        this.reply(null, true, "REQUEST_CANCELED", "REQUEST_CANCELED", "NA", -1);
                        break;
                    }
                    case PROCESS_ON_EXCEPTION: {
                        String displayError = PcErrorMsgUtils.replaceErrorMsg(this.cause.toString());
                        String stackTrace = PcStringUtils.printStackTrace(this.cause);
                        this.cancelCancellable();
                        this.reply(null, true, displayError, stackTrace, "NA", -1);
                        break;
                    }
                    case PROCESS_ON_TIMEOUT: {
                        PingWorker.getLogger().error("Inside PROCESS_ON_TIMEOUT.................target: " + this.targetHost + "......... at " + PcDateUtils.getNowDateTimeStrStandard());
                        this.cancelCancellable();
                        String errorMsg = String.format("SshWorker Timedout after %d SEC (no response but no exception catched). Details more info", this.actorMaxOperationTimeoutSec);
                        this.reply(null, true, errorMsg, errorMsg, "NA", -1);
                        break;
                    }
                }
            } else {
                this.unhandled(message);
                this.sender = this.getSender();
                this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for host " + this.targetHost);
                this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
            }
        }
        catch (Exception e) {
            this.cause = e;
            this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
        }
    }

    public void onComplete(ResponseOnSingeRequest pingResponse) {
        this.cancelCancellable();
        this.reply(pingResponse.getResponseBody(), pingResponse.isFailObtainResponse(), pingResponse.getErrorMessage(), null, pingResponse.getStatusCode(), pingResponse.getStatusCodeInt());
    }

    public void cancelCancellable() {
        if (this.timeoutMessageCancellable != null) {
            this.timeoutMessageCancellable.cancel();
        }
        if (this.getResponseFuture() != null && !this.getResponseFuture().isDone()) {
            this.getResponseFuture().cancel(true);
        }
    }

    private void reply(String response, boolean failObtainResponse, String errorMessage, String stackTrace, String statusCode, int statusCodeInt) {
        if (!this.isSentReply()) {
            this.sentReply = true;
            ResponseOnSingeRequest res = new ResponseOnSingeRequest(response, failObtainResponse, errorMessage, stackTrace, statusCode, statusCodeInt, PcDateUtils.getNowDateTimeStrStandard(), null);
            if (!this.getContext().system().deadLetters().equals((Object)this.sender)) {
                this.sender.tell((Object)res, this.getSelf());
            }
            if (this.getContext() != null) {
                this.getContext().stop(this.getSelf());
            }
        }
    }

    public boolean isSentReply() {
        return this.sentReply;
    }

    public Future<ResponseOnSingeRequest> getResponseFuture() {
        return this.responseFuture;
    }

    public void setResponseFuture(Future<ResponseOnSingeRequest> responseFuture) {
        this.responseFuture = responseFuture;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        PingWorker.logger = logger;
    }

    private static class PingTask
    implements Callable<ResponseOnSingeRequest> {
        private String targetHost;
        private PingMeta pingMeta;

        public PingTask(String targetHost, PingMeta pingMeta) {
            this.targetHost = targetHost;
            this.pingMeta = pingMeta;
        }

        @Override
        public ResponseOnSingeRequest call() throws Exception {
            boolean live = PingProvider.getInstance().isReachableByPing(this.targetHost, this.pingMeta);
            ResponseOnSingeRequest pingResponse = new ResponseOnSingeRequest();
            pingResponse.setResponseBody(Boolean.toString(live));
            pingResponse.setStatusCode(live ? "LIVE" : "UNREACHABLE");
            pingResponse.setFailObtainResponse(false);
            return pingResponse;
        }
    }
}

