/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.UntypedActor;
import io.parallec.core.actor.message.ResponseOnSingeRequest;
import io.parallec.core.actor.message.type.RequestWorkerMsgType;
import io.parallec.core.bean.udp.UdpMeta;
import io.parallec.core.exception.ActorMessageTypeInvalidException;
import io.parallec.core.exception.HttpRequestCreateException;
import io.parallec.core.exception.TcpUdpRequestCreateException;
import io.parallec.core.resources.TcpUdpSshPingResourceStore;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcErrorMsgUtils;
import io.parallec.core.util.PcStringUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class UdpWorker
extends UntypedActor {
    private int actorMaxOperationTimeoutSec;
    private final UdpMeta udpMeta;
    private String targetHost;
    private static Logger logger = LoggerFactory.getLogger(UdpWorker.class);
    private ActorRef sender = null;
    private Throwable cause;
    private int tryCount = 0;
    private Cancellable timeoutMessageCancellable = null;
    private FiniteDuration timeoutDuration = null;
    private boolean sentReply = false;
    private Channel channel = null;
    private StringBuilder responseSb = new StringBuilder();

    public UdpWorker(int actorMaxOperationTimeoutSec, UdpMeta udpMeta, String targetHost) {
        this.actorMaxOperationTimeoutSec = actorMaxOperationTimeoutSec;
        this.udpMeta = udpMeta;
        this.targetHost = targetHost;
    }

    public ConnectionlessBootstrap bootStrapUdpClient() throws HttpRequestCreateException {
        ConnectionlessBootstrap udpClient = null;
        try {
            udpClient = new ConnectionlessBootstrap(this.udpMeta.getChannelFactory());
            udpClient.setPipeline(new UdpPipelineFactory((Timer)TcpUdpSshPingResourceStore.getInstance().getTimer(), this).getPipeline());
        }
        catch (Exception t) {
            throw new TcpUdpRequestCreateException("Error in creating request in udp worker.  If udpClient is null. Then fail to create.", t);
        }
        return udpClient;
    }

    public void onReceive(Object message) throws Exception {
        block12: {
            try {
                if (message instanceof RequestWorkerMsgType) {
                    switch ((RequestWorkerMsgType)((Object)message)) {
                        case PROCESS_REQUEST: {
                            ++this.tryCount;
                            if (this.tryCount == 1) {
                                this.sender = this.getSender();
                                ConnectionlessBootstrap udpClient = this.bootStrapUdpClient();
                                ChannelFuture future = udpClient.connect((SocketAddress)new InetSocketAddress(this.targetHost, (int)this.udpMeta.getUdpPort()));
                                this.timeoutDuration = Duration.create((long)this.actorMaxOperationTimeoutSec, (TimeUnit)TimeUnit.SECONDS);
                                this.timeoutMessageCancellable = this.getContext().system().scheduler().scheduleOnce(this.timeoutDuration, this.getSelf(), (Object)RequestWorkerMsgType.PROCESS_ON_TIMEOUT, (ExecutionContext)this.getContext().system().dispatcher(), this.getSelf());
                                this.channel = future.awaitUninterruptibly().getChannel();
                                ChannelFuture requestFuture = null;
                                requestFuture = this.channel.write((Object)(this.udpMeta.getCommand() + "\r\n"));
                                if (requestFuture != null) {
                                    requestFuture.await();
                                    break;
                                }
                                break block12;
                            }
                            UdpWorker.getLogger().error("duplicated PROCESS_REQUEST msg. ignore...");
                            break;
                        }
                        case CANCEL: {
                            if (this.sender == null) {
                                this.sender = this.getSender();
                            }
                            UdpWorker.getLogger().info("UDP Request was CANCELLED.................{}", (Object)this.targetHost);
                            this.cancelCancellable();
                            this.reply(null, true, "REQUEST_CANCELED", "REQUEST_CANCELED", "NA", -1);
                            break;
                        }
                        case PROCESS_ON_EXCEPTION: {
                            String errorSummary = PcErrorMsgUtils.replaceErrorMsg(this.cause.toString());
                            String stackTrace = PcStringUtils.printStackTrace(this.cause);
                            this.cancelCancellable();
                            this.reply(null, true, errorSummary, stackTrace, "NA", -1);
                            break;
                        }
                        case PROCESS_ON_TIMEOUT: {
                            UdpWorker.getLogger().error("PROCESS_ON_TIMEOUT.................{}", (Object)this.targetHost);
                            this.cancelCancellable();
                            String errorMsg = String.format("UdpWorker Timedout after %d SEC (no response but no exception catched). Check URL: may be very slow or stuck.", this.actorMaxOperationTimeoutSec);
                            this.reply(null, true, errorMsg, errorMsg, "NA", -1);
                            break;
                        }
                        default: {
                            this.sender = this.getSender();
                            this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for on " + this.targetHost);
                            this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
                            break;
                        }
                    }
                    break block12;
                }
                this.unhandled(message);
                this.sender = this.getSender();
                this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for UDP on " + this.targetHost);
                this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
            }
            catch (Exception e) {
                this.cause = e;
                this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
            }
        }
    }

    public void cancelCancellable() {
        if (this.timeoutMessageCancellable != null) {
            this.timeoutMessageCancellable.cancel();
        }
    }

    private void reply(String response, boolean error, String errorMessage, String stackTrace, String statusCode, int statusCodeInt) {
        if (!this.sentReply) {
            this.sentReply = true;
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().awaitUninterruptibly();
            }
            ResponseOnSingeRequest res = new ResponseOnSingeRequest(response, error, errorMessage, stackTrace, statusCode, statusCodeInt, PcDateUtils.getNowDateTimeStrStandard(), null);
            if (!this.getContext().system().deadLetters().equals((Object)this.sender)) {
                this.sender.tell((Object)res, this.getSelf());
            }
            if (this.getContext() != null) {
                this.getContext().stop(this.getSelf());
            }
        }
    }

    public void onComplete(String response, boolean error, String errorMessage, String stackTrace, String statusCode, int statusCodeInt) {
        this.cancelCancellable();
        this.reply(response, error, errorMessage, stackTrace, statusCode, statusCodeInt);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        UdpWorker.logger = logger;
    }

    public static class UdpChannelHandler
    extends SimpleChannelUpstreamHandler {
        public boolean hasCaughtException = false;
        private final UdpWorker udpWorker;
        private int msgRecvCount = 0;

        public UdpChannelHandler(UdpWorker udpWorker) {
            this.udpWorker = udpWorker;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            this.udpWorker.responseSb.append(e.getMessage().toString() + "\n");
            logger.debug("DONE." + ++this.msgRecvCount);
            logger.debug("MSG_RECEIVED_AT_UDP_CLIENT: {}", (Object)e.getMessage().toString());
            int statusCodeInt = 0;
            String statusCode = statusCodeInt + " SUCCESSFUL";
            this.udpWorker.onComplete(this.udpWorker.responseSb.toString(), false, null, null, statusCode, statusCodeInt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            if (!this.hasCaughtException) {
                this.hasCaughtException = true;
                String errMsg = e.getCause().toString();
                logger.debug("UDP Handler exceptionCaught: {} . ", (Object)errMsg);
                e.getChannel().close();
                int statusCodeInt = 1;
                String statusCode = statusCodeInt + " FAILURE";
                this.udpWorker.onComplete(this.udpWorker.responseSb.toString(), true, errMsg, errMsg, statusCode, statusCodeInt);
            }
        }
    }

    public static class MyIdleHandler
    extends IdleStateAwareChannelHandler {
        private final UdpWorker udpWorker;

        public MyIdleHandler(UdpWorker udpWorker) {
            this.udpWorker = udpWorker;
        }

        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
            logger.debug("In IDLE event handler for UDP..timeout.");
            if (e.getState() == IdleState.ALL_IDLE) {
                int statusCodeInt = 1;
                String statusCode = statusCodeInt + " FAILURE";
                String errMsg = "UDP idle (read) timeout";
                this.udpWorker.onComplete(this.udpWorker.responseSb.toString(), true, errMsg, errMsg, statusCode, statusCodeInt);
            }
        }
    }

    public static class UdpPipelineFactory
    implements ChannelPipelineFactory {
        private final ChannelHandler idleStateHandler;
        private final UdpWorker udpWorker;
        private final MyIdleHandler myIdleHandler;

        public UdpPipelineFactory(Timer timer, UdpWorker udpWorker) {
            this.udpWorker = udpWorker;
            this.idleStateHandler = new IdleStateHandler(timer, 0, 0, udpWorker.udpMeta.getUdpIdleTimeoutSec().intValue());
            this.myIdleHandler = new MyIdleHandler(udpWorker);
        }

        public ChannelPipeline getPipeline() {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("idleTimer", this.idleStateHandler);
            pipeline.addLast("idleHandler", (ChannelHandler)this.myIdleHandler);
            pipeline.addLast("stringDecoder", UdpMeta.stringDecoder);
            pipeline.addLast("stringEncoder", UdpMeta.stringEncoder);
            pipeline.addLast("UDPUpstreamHandler", (ChannelHandler)new UdpChannelHandler(this.udpWorker));
            return pipeline;
        }
    }
}

