/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor.message;

import io.parallec.core.ResponseOnSingleTask;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeReqResponse {
    private static Logger logger = LoggerFactory.getLogger(NodeReqResponse.class);
    private final Map<String, String> requestParameters = new LinkedHashMap<String, String>();
    private String hostName;
    private ResponseOnSingleTask singleTaskResponse = null;

    public String toString() {
        return "NodeReqResponse [requestParameters=" + this.requestParameters + ", singleTaskResponse=" + this.singleTaskResponse + "]";
    }

    public NodeReqResponse(String hostName) {
        this.setHostName(hostName);
    }

    public static String replaceStrByMap(Map<String, String> requestParameters, String sourceContent) {
        String contentAfterReplace = sourceContent;
        for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
            String sourceContentHelperNew = contentAfterReplace;
            String varName = entry.getKey();
            String replacement = entry.getValue();
            if (!varName.contains("REPLACE-VAR_")) continue;
            String varTrueName = "$" + varName.replace("REPLACE-VAR_", "");
            contentAfterReplace = sourceContentHelperNew = contentAfterReplace.replace(varTrueName, replacement);
        }
        return contentAfterReplace;
    }

    public void setDefaultReqestContent(String requestFullContent) {
        this.requestParameters.put("PARALLEC_EMPTY_REQUEST_BODY", requestFullContent);
    }

    public void setDefaultEmptyReqestContent() {
        this.requestParameters.put("PARALLEC_EMPTY_REQUEST_BODY", "");
    }

    public void setCustomReqestContent(String requestVarName, String requestVarContent) {
        this.requestParameters.put(requestVarName, requestVarContent);
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public ResponseOnSingleTask getSingleTaskResponse() {
        return this.singleTaskResponse;
    }

    public void setSingleTaskResponse(ResponseOnSingleTask singleTaskResponse) {
        this.singleTaskResponse = singleTaskResponse;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }
}

