/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.commander.workflow.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.parallec.core.actor.message.ResponseOnSingeRequest;
import io.parallec.core.bean.ssh.SshLoginType;
import io.parallec.core.bean.ssh.SshMeta;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.util.PcErrorMsgUtils;
import io.parallec.core.util.PcFileNetworkIoUtils;
import io.parallec.core.util.PcStringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshProvider {
    private static Logger logger = LoggerFactory.getLogger(SshProvider.class);
    private SshMeta sshMeta;
    private String targetHost;
    private Session session = null;
    private Channel channel = null;

    public SshProvider(SshMeta sshMeta, String targetHost) {
        this.sshMeta = sshMeta;
        this.targetHost = targetHost;
    }

    public SshProvider() {
    }

    public ResponseOnSingeRequest executeSshCommand() {
        ResponseOnSingeRequest sshResponse = new ResponseOnSingeRequest();
        try {
            this.session = this.startSshSessionAndObtainSession();
            this.channel = this.sessionConnectGenerateChannel(this.session);
            sshResponse = this.executeAndGenResponse((ChannelExec)this.channel);
        }
        catch (Exception e) {
            sshResponse = this.genErrorResponse(e);
        }
        finally {
            if (this.session != null) {
                this.session.disconnect();
            }
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
        return sshResponse;
    }

    public Session startSshSessionAndObtainSession() {
        Session session = null;
        try {
            JSch jsch = new JSch();
            if (this.sshMeta.getSshLoginType() == SshLoginType.KEY) {
                String workingDir = System.getProperty("user.dir");
                String privKeyAbsPath = workingDir + "/" + this.sshMeta.getPrivKeyRelativePath();
                logger.debug("use privkey: path: " + privKeyAbsPath);
                if (!PcFileNetworkIoUtils.isFileExist(privKeyAbsPath)) {
                    throw new RuntimeException("file not found at " + privKeyAbsPath);
                }
                if (this.sshMeta.isPrivKeyUsePassphrase() && this.sshMeta.getPassphrase() != null) {
                    jsch.addIdentity(privKeyAbsPath, this.sshMeta.getPassphrase());
                } else {
                    jsch.addIdentity(privKeyAbsPath);
                }
            }
            session = jsch.getSession(this.sshMeta.getUserName(), this.targetHost, this.sshMeta.getSshPort());
            if (this.sshMeta.getSshLoginType() == SshLoginType.PASSWORD) {
                session.setPassword(this.sshMeta.getPassword());
            }
            session.setConfig("StrictHostKeyChecking", "no");
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
        return session;
    }

    public Channel sessionConnectGenerateChannel(Session session) throws JSchException {
        session.connect(this.sshMeta.getSshConnectionTimeoutMillis());
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setCommand(this.sshMeta.getCommandLine());
        if (this.sshMeta.isRunAsSuperUser()) {
            try {
                channel.setInputStream(null, true);
                OutputStream out = channel.getOutputStream();
                channel.setOutputStream((OutputStream)System.out, true);
                channel.setExtOutputStream((OutputStream)System.err, true);
                channel.setPty(true);
                channel.connect();
                out.write((this.sshMeta.getPassword() + "\n").getBytes());
                out.flush();
            }
            catch (IOException e) {
                logger.error("error in sessionConnectGenerateChannel for super user", (Throwable)e);
            }
        } else {
            channel.setInputStream(null);
            channel.connect();
        }
        return channel;
    }

    public ResponseOnSingeRequest executeAndGenResponse(ChannelExec channel) {
        ResponseOnSingeRequest sshResponse = new ResponseOnSingeRequest();
        InputStream in = null;
        ByteArrayOutputStream outputStreamStdErr = new ByteArrayOutputStream();
        StringBuilder sbStdOut = new StringBuilder();
        try {
            in = channel.getInputStream();
            channel.setErrStream((OutputStream)outputStreamStdErr);
            byte[] tmp = new byte[ParallecGlobalConfig.sshBufferSize];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, ParallecGlobalConfig.sshBufferSize)) >= 0) {
                    sbStdOut.append(new String(tmp, 0, i));
                    continue;
                }
                if (channel.isClosed()) {
                    if (in.available() > 0) continue;
                    break;
                }
                Thread.sleep(ParallecGlobalConfig.sshSleepMIllisBtwReadBuffer);
            }
            sshResponse.setFailObtainResponse(false);
            int exitStatus = channel.getExitStatus();
            sshResponse.setStatusCodeInt(exitStatus);
            sshResponse.setStatusCode(Integer.toString(exitStatus));
            sshResponse.setResponseBody(sbStdOut.toString());
            sshResponse.setErrorMessage(((Object)outputStreamStdErr).toString());
            sshResponse.setReceiveTimeNow();
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
        return sshResponse;
    }

    public ResponseOnSingeRequest genErrorResponse(Exception t) {
        ResponseOnSingeRequest sshResponse = new ResponseOnSingeRequest();
        String displayError = PcErrorMsgUtils.replaceErrorMsg(t.toString());
        sshResponse.setStackTrace(PcStringUtils.printStackTrace(t));
        sshResponse.setErrorMessage(displayError);
        sshResponse.setFailObtainResponse(true);
        logger.error("error in exec SSH. \nIf exection is JSchException: Auth cancel and using public key. \nMake sure 1. private key full path is right (try sshMeta.getPrivKeyAbsPath()). \n2. the user name and key matches  " + t);
        return sshResponse;
    }

    public SshMeta getSshMeta() {
        return this.sshMeta;
    }

    public void setSshMeta(SshMeta sshMeta) {
        this.sshMeta = sshMeta;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public void setTargetHost(String targetHost) {
        this.targetHost = targetHost;
    }
}

