/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.resources;

import com.ning.http.client.AsyncHttpClient;
import io.parallec.core.resources.AsyncHttpClientFactoryEmbed;
import io.parallec.core.resources.HttpClientType;
import java.util.HashMap;
import java.util.Map;

public class HttpClientStore {
    private HttpClientType httpClientTypeCurrentDefault;
    private final Map<HttpClientType, AsyncHttpClient> map = new HashMap<HttpClientType, AsyncHttpClient>();
    private AsyncHttpClientFactoryEmbed httpClientFactoryEmbed;
    private static final HttpClientStore instance = new HttpClientStore();

    public static HttpClientStore getInstance() {
        return instance;
    }

    private HttpClientStore() {
        this.init();
    }

    public synchronized void init() {
        this.httpClientFactoryEmbed = new AsyncHttpClientFactoryEmbed();
        this.map.put(HttpClientType.EMBED_FAST, this.httpClientFactoryEmbed.getFastClient());
        this.map.put(HttpClientType.EMBED_SLOW, this.httpClientFactoryEmbed.getSlowClient());
        this.map.put(HttpClientType.CUSTOM_FAST, this.httpClientFactoryEmbed.getFastClient());
        this.map.put(HttpClientType.CUSTOM_SLOW, this.httpClientFactoryEmbed.getSlowClient());
        this.setHttpClientTypeCurrentDefault(HttpClientType.EMBED_FAST);
    }

    public synchronized void reinit() {
        this.shutdown();
        this.init();
    }

    public void shutdown() {
        for (Map.Entry<HttpClientType, AsyncHttpClient> entry : this.map.entrySet()) {
            AsyncHttpClient client = entry.getValue();
            if (client == null) continue;
            client.close();
        }
    }

    public AsyncHttpClient getEmbedClientFast() {
        return this.map.get((Object)HttpClientType.EMBED_FAST);
    }

    public AsyncHttpClient getEmbedClientSlow() {
        return this.map.get((Object)HttpClientType.EMBED_SLOW);
    }

    public AsyncHttpClient getCustomClientFast() {
        return this.map.get((Object)HttpClientType.CUSTOM_FAST);
    }

    public AsyncHttpClient getCustomClientSlow() {
        return this.map.get((Object)HttpClientType.CUSTOM_SLOW);
    }

    public AsyncHttpClient getClientByType(HttpClientType type) {
        return this.map.get((Object)type);
    }

    public AsyncHttpClient getCurrentDefaultClient() {
        return this.map.get((Object)this.httpClientTypeCurrentDefault);
    }

    public void setCustomClientFast(AsyncHttpClient client) {
        this.map.put(HttpClientType.CUSTOM_FAST, client);
    }

    public void setCustomClientSlow(AsyncHttpClient client) {
        this.map.put(HttpClientType.CUSTOM_SLOW, client);
    }

    public HttpClientType getHttpClientTypeCurrentDefault() {
        return this.httpClientTypeCurrentDefault;
    }

    public void setHttpClientTypeCurrentDefault(HttpClientType httpClientTypeCurrentDefault) {
        this.httpClientTypeCurrentDefault = httpClientTypeCurrentDefault;
    }

    public Map<HttpClientType, AsyncHttpClient> getMap() {
        return this.map;
    }

    public AsyncHttpClientFactoryEmbed getHttpClientFactoryEmbed() {
        return this.httpClientFactoryEmbed;
    }

    public void setHttpClientFactoryEmbed(AsyncHttpClientFactoryEmbed httpClientFactoryEmbed) {
        this.httpClientFactoryEmbed = httpClientFactoryEmbed;
    }
}

