/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.resources;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;

public class TcpUdpSshPingResourceStore {
    private static final TcpUdpSshPingResourceStore instance = new TcpUdpSshPingResourceStore();
    private ChannelFactory channelFactory;
    private DatagramChannelFactory datagramChannelFactory;
    private HashedWheelTimer timer = null;
    private ExecutorService threadPoolForSshPing = Executors.newCachedThreadPool();

    public static TcpUdpSshPingResourceStore getInstance() {
        return instance;
    }

    public void shutdown() {
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
        if (this.datagramChannelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private TcpUdpSshPingResourceStore() {
        this.init();
    }

    public synchronized void init() {
        this.channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.datagramChannelFactory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool());
        this.timer = new HashedWheelTimer();
    }

    public synchronized void reinit() {
        this.shutdown();
        this.init();
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public HashedWheelTimer getTimer() {
        return this.timer;
    }

    public void setTimer(HashedWheelTimer timer) {
        this.timer = timer;
    }

    public ExecutorService getThreadPoolForSshPing() {
        return this.threadPoolForSshPing;
    }

    public void setThreadPoolForSshPing(ExecutorService threadPoolForSshPing) {
        this.threadPoolForSshPing = threadPoolForSshPing;
    }

    public DatagramChannelFactory getDatagramChannelFactory() {
        return this.datagramChannelFactory;
    }

    public void setDatagramChannelFactory(DatagramChannelFactory datagramChannelFactory) {
        this.datagramChannelFactory = datagramChannelFactory;
    }
}

