/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium;

import io.appium.java_client.AppiumDriver;

public class Environment {
    private AppiumDriver driver;
    public static final String SDK_VERSION = "2.1.0-beta.0";
    private static final String SDK_NAME = "percy-appium-app";
    private static String percyBuildID;
    private static String percyBuildUrl;
    private static String sessionType;

    public Environment(AppiumDriver driver) {
        this.driver = driver;
    }

    public String getClientInfo(Boolean flag) {
        if (flag.booleanValue()) {
            return "percy-appium-app-java/2.1.0-beta.0";
        }
        return "percy-appium-app/2.1.0-beta.0";
    }

    public String getEnvironmentInfo() {
        String[] splitDriverName = this.driver.getClass().getName().split("\\.");
        String driverName = splitDriverName[splitDriverName.length - 1];
        return String.format("appium-java; %s", driverName);
    }

    public static String getPercyBuildID() {
        return percyBuildID;
    }

    public static void setPercyBuildID(String buildIDParam) {
        percyBuildID = buildIDParam;
    }

    public static String getPercyBuildUrl() {
        return percyBuildUrl;
    }

    public static void setPercyBuildUrl(String buildUrlParam) {
        percyBuildUrl = buildUrlParam;
    }

    public static Boolean getForceFullPage() {
        return System.getenv().getOrDefault("FORCE_FULL_PAGE", "false").equals("true");
    }

    public static Boolean getDisableRemoteUploads() {
        return System.getenv().getOrDefault("PERCY_DISABLE_REMOTE_UPLOADS", "false").equals("true");
    }

    public static Boolean getEnablePercyDev() {
        return System.getenv().getOrDefault("PERCY_ENABLE_DEV", "false").equals("true");
    }

    public static String getSessionType() {
        return sessionType;
    }

    public static void setSessionType(String type) {
        sessionType = type;
    }
}

