/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.lib;

import io.appium.java_client.AppiumDriver;
import io.percy.appium.AppPercy;
import io.percy.appium.Environment;
import io.percy.appium.lib.Tile;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class CliWrapper {
    private static String PERCY_SERVER_ADDRESS = System.getenv().getOrDefault("PERCY_SERVER_ADDRESS", "http://localhost:5338");
    private Environment env;

    public CliWrapper(AppiumDriver driver) {
        this.env = new Environment(driver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean healthcheck() {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpGet httpget = new HttpGet(PERCY_SERVER_ADDRESS + "/percy/healthcheck");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            JSONObject myObject = new JSONObject(responseString);
            JSONObject buildJsonObject = (JSONObject)myObject.get("build");
            Environment.setPercyBuildID((String)buildJsonObject.get("id"));
            Environment.setPercyBuildUrl((String)buildJsonObject.get("url"));
            Environment.setSessionType(myObject.optString("type", null));
            if (statusCode != 200) {
                throw new RuntimeException("Failed with HTTP error code : " + statusCode);
            }
            String version = response.getFirstHeader("x-percy-core-version").getValue();
            Integer majorVersion = Integer.parseInt(version.split("\\.")[0]);
            Integer minorVersion = Integer.parseInt(version.split("\\.")[1]);
            if (majorVersion < 1) {
                AppPercy.log("Unsupported Percy CLI version, " + version);
                boolean bl = false;
                return bl;
            }
            if (minorVersion < 27) {
                AppPercy.log("Percy CLI version, " + version + " is not minimum version required Percy on Automate is available from 1.27.0-beta.0.", "warn");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            AppPercy.log("Percy is not running, disabling screenshots");
            AppPercy.log(ex.toString(), "debug");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String postScreenshot(String name, JSONObject tag, List<Tile> tiles, String externalDebugUrl, JSONObject ignoredElementsData, JSONObject consideredElementsData) {
        JSONObject data = new JSONObject();
        data.put("name", (Object)name);
        data.put("tag", (Object)tag);
        data.put("tiles", Tile.getTilesAsJson(tiles));
        data.put("externalDebugUrl", (Object)externalDebugUrl);
        data.put("ignoredElementsData", (Object)ignoredElementsData);
        data.put("consideredElementsData", (Object)consideredElementsData);
        data.put("clientInfo", (Object)this.env.getClientInfo(false));
        data.put("environmentInfo", (Object)this.env.getEnvironmentInfo());
        StringEntity entity = new StringEntity(data.toString(), ContentType.APPLICATION_JSON);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpPost request = new HttpPost(PERCY_SERVER_ADDRESS + "/percy/comparison");
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            JSONObject jsonResponse = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            String string = jsonResponse.getString("link");
            return string;
        }
        catch (Exception ex) {
            AppPercy.log(ex.toString(), "debug");
            AppPercy.log("Could not post screenshot " + name);
            return null;
        }
    }

    public void postFailedEvent(String err) {
        JSONObject data = new JSONObject();
        data.put("clientInfo", (Object)this.env.getClientInfo(true));
        data.put("message", (Object)err);
        data.put("errroKind", (Object)"sdk");
        StringEntity entity = new StringEntity(data.toString(), ContentType.APPLICATION_JSON);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpPost request = new HttpPost(PERCY_SERVER_ADDRESS + "/percy/events");
            request.setEntity((HttpEntity)entity);
            httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception ex) {
            AppPercy.log(ex.toString(), "debug");
        }
    }

    public String postScreenshotPOA(String name, String sessionId, String commandExecutorUrl, Map<String, Object> capabilities, Map<String, Object> options) {
        JSONObject data = new JSONObject();
        data.put("snapshotName", (Object)name);
        data.put("sessionId", (Object)sessionId);
        data.put("commandExecutorUrl", (Object)commandExecutorUrl);
        data.put("capabilities", capabilities);
        data.put("options", options);
        data.put("clientInfo", (Object)this.env.getClientInfo(false));
        data.put("environmentInfo", (Object)this.env.getEnvironmentInfo());
        StringEntity entity = new StringEntity(data.toString(), ContentType.APPLICATION_JSON);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpPost request = new HttpPost(PERCY_SERVER_ADDRESS + "/percy/automateScreenshot");
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception ex) {
            AppPercy.log(ex.toString(), "debug");
            AppPercy.log("Could not post screenshot " + name);
        }
        return null;
    }
}

