/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.lib;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class Tile {
    private String localFilePath;
    private String sha;
    private Integer statusBarHeight;
    private Integer navBarHeight;
    private Integer headerHeight;
    private Integer footerHeight;
    private Boolean fullScreen;

    public Tile(String localFilePath, Integer statusBarHeight, Integer navBarHeight, Integer headerHeight, Integer footerHeight, Boolean fullScreen, String sha) {
        this.localFilePath = localFilePath;
        this.statusBarHeight = statusBarHeight;
        this.navBarHeight = navBarHeight;
        this.headerHeight = headerHeight;
        this.footerHeight = footerHeight;
        this.fullScreen = fullScreen;
        this.sha = sha;
    }

    public static List<JSONObject> getTilesAsJson(List<Tile> tilesList) {
        ArrayList<JSONObject> tiles = new ArrayList<JSONObject>();
        for (Tile tile : tilesList) {
            JSONObject tileData = new JSONObject();
            tileData.put("filepath", (Object)tile.localFilePath);
            tileData.put("statusBarHeight", (Object)tile.statusBarHeight);
            tileData.put("navBarHeight", (Object)tile.navBarHeight);
            tileData.put("headerHeight", (Object)tile.headerHeight);
            tileData.put("footerHeight", (Object)tile.footerHeight);
            tileData.put("fullscreen", (Object)tile.fullScreen);
            tileData.put("sha", (Object)tile.sha);
            tiles.add(tileData);
        }
        return tiles;
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    public String getSha() {
        return this.sha;
    }

    public Integer getStatusBarHeight() {
        return this.statusBarHeight;
    }

    public Integer getNavBarHeight() {
        return this.navBarHeight;
    }

    public Integer getHeaderHeight() {
        return this.headerHeight;
    }

    public Integer getFooterHeight() {
        return this.footerHeight;
    }

    public Boolean getFullScreen() {
        return this.fullScreen;
    }
}

