/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.metadata;

import io.appium.java_client.AppiumDriver;
import io.percy.appium.lib.Cache;
import java.util.Map;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public abstract class Metadata {
    private static AppiumDriver driver;
    private String orientation;
    private String platformVersion;
    private Integer statusBar;
    private Integer navBar;
    private String deviceName;
    private String sessionId;

    public Metadata(AppiumDriver driver, String deviceName, Integer statusBar, Integer navBar, String orientation, String platformVersion) {
        Metadata.driver = driver;
        this.platformVersion = platformVersion;
        this.orientation = orientation;
        this.statusBar = statusBar;
        this.navBar = navBar;
        this.deviceName = deviceName;
        this.sessionId = driver.getSessionId().toString();
    }

    public String osName() {
        String osName = driver.getCapabilities().getCapability("platformName").toString();
        return osName.substring(0, 1).toUpperCase() + osName.substring(1).toLowerCase();
    }

    public String platformVersion() {
        if (this.platformVersion != null) {
            return this.platformVersion;
        }
        Object osVersion = driver.getCapabilities().getCapability("platformVersion");
        if (osVersion == null && (osVersion = driver.getCapabilities().getCapability("os_version")) == null) {
            return null;
        }
        return osVersion.toString();
    }

    public String orientation() {
        if (this.orientation != null) {
            if (this.orientation.toLowerCase().equals("portrait") || this.orientation.toLowerCase().equals("landscape")) {
                return this.orientation.toLowerCase();
            }
            if (this.orientation.toLowerCase().equals("auto")) {
                try {
                    return driver.getOrientation().toString().toLowerCase();
                }
                catch (NoSuchMethodError e) {
                    return "portrait";
                }
            }
            return "portrait";
        }
        Object orientationCapability = driver.getCapabilities().getCapability("orientation");
        if (orientationCapability != null) {
            return orientationCapability.toString().toLowerCase();
        }
        return "portrait";
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Integer getNavBar() {
        return this.navBar;
    }

    public Integer getStatusBar() {
        return this.statusBar;
    }

    public Map getSession() {
        if (Cache.CACHE_MAP.get("getSession_" + this.sessionId) == null) {
            driver.addCommand(HttpMethod.GET, "/session/" + driver.getSessionId(), "getSession");
            Response session = driver.execute("getSession");
            Cache.CACHE_MAP.put("getSession_" + this.sessionId, session.getValue());
        }
        return (Map)Cache.CACHE_MAP.get("getSession_" + this.sessionId);
    }

    public abstract Integer deviceScreenWidth();

    public abstract String deviceName();

    public abstract Integer deviceScreenHeight();

    public abstract Integer statBarHeight();

    public abstract Integer navBarHeight();

    public abstract Integer scaleFactor();
}

