/*
 * Decompiled with CFR 0.152.
 */
package io.percy.appium.metadata;

import io.appium.java_client.AppiumDriver;
import io.percy.appium.AppPercy;
import io.percy.appium.lib.Cache;
import io.percy.appium.metadata.AndroidMetadata;
import io.percy.appium.metadata.IosMetadata;
import io.percy.appium.metadata.Metadata;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MetadataHelper {
    public static Metadata resolve(AppiumDriver driver, String deviceName, Integer statusBar, Integer navBar, String orientation, String platformVersion) {
        String driverClass = "";
        try {
            driverClass = driver.getClass().toString();
            if (driverClass.contains("AndroidDriver")) {
                return new AndroidMetadata(driver, deviceName, statusBar, navBar, orientation, platformVersion);
            }
            if (driverClass.contains("IOSDriver")) {
                return new IosMetadata(driver, deviceName, statusBar, navBar, orientation, platformVersion);
            }
            throw new Exception("Driver class not found");
        }
        catch (Exception e) {
            AppPercy.log("Unsupported driver class, " + driverClass);
            return null;
        }
    }

    public static Integer valueFromStaticDevicesInfo(String key, String deviceName) {
        try {
            JSONObject object = MetadataHelper.getDevicesJson().getJSONObject(deviceName);
            return object.getInt(key);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public static JSONObject getDevicesJson() {
        if (Cache.CACHE_MAP.get("getDevicesJson") == null) {
            InputStream inputStream = MetadataHelper.class.getResourceAsStream("/devices.json");
            JSONTokener tokener = new JSONTokener(inputStream);
            JSONObject devicesJsonObject = new JSONObject(tokener);
            Cache.CACHE_MAP.put("getDevicesJson", devicesJsonObject);
        }
        return (JSONObject)Cache.CACHE_MAP.get("getDevicesJson");
    }
}

