/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.Impl;
import io.perfmark.Link;
import io.perfmark.StringFunction;
import io.perfmark.Tag;
import io.perfmark.impl.Generator;
import io.perfmark.impl.MarkRecorder;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

final class SecretPerfMarkImpl {
    private SecretPerfMarkImpl() {
    }

    public static final class PerfMarkImpl
    extends Impl {
        private static final int ENABLED_BIT_SPACE = 2;
        private static final int GEN_TIMESTAMP_SPACE = 54;
        private static final long MAX_MIBROS = 0x3FFFFFFFFFFFFFL;
        private static final Tag NO_TAG;
        private static final Link NO_LINK;
        private static final long INCREMENT = 256L;
        private static final AtomicLong linkIdAlloc;
        private static final Generator generator;
        private static final MarkRecorder markRecorder;
        private static final Object logger;
        private static long actualGeneration;

        public PerfMarkImpl(Tag key) {
            super(key);
        }

        protected synchronized void setEnabled(boolean value) {
            boolean changed = PerfMarkImpl.setEnabledQuiet(value, System.nanoTime());
            PerfMarkImpl.logEnabledChange(value, changed);
        }

        protected synchronized boolean setEnabled(boolean value, boolean overload) {
            boolean changed = PerfMarkImpl.setEnabledQuiet(value, System.nanoTime());
            PerfMarkImpl.logEnabledChange(value, changed);
            return changed;
        }

        private static synchronized void logEnabledChange(boolean value, boolean success) {
            Logger localLogger;
            if (success && logger != null && (localLogger = (Logger)logger).isLoggable(Level.FINE)) {
                localLogger.fine((value ? "Enabling" : "Disabling") + " PerfMark recorder");
            }
        }

        private static synchronized boolean setEnabledQuiet(boolean value, long now) {
            if (PerfMarkImpl.isEnabled(actualGeneration) == value) {
                return false;
            }
            if (actualGeneration == -512L) {
                return false;
            }
            long nanoDiff = now - Generator.INIT_NANO_TIME;
            actualGeneration = PerfMarkImpl.nextGeneration(actualGeneration, nanoDiff);
            generator.setGeneration(actualGeneration);
            return true;
        }

        static long nextGeneration(long currentGeneration, long nanosSinceInit) {
            boolean nextEnabled;
            long currentMibros = PerfMarkImpl.mibrosFromGeneration(currentGeneration);
            long mibrosSinceInit = Math.min(PerfMarkImpl.mibrosFromNanos(nanosSinceInit), 0x3FFFFFFFFFFFFFL);
            boolean bl = nextEnabled = !PerfMarkImpl.isEnabled(currentGeneration);
            long nextMibros = mibrosSinceInit > currentMibros ? mibrosSinceInit : currentMibros + (long)(nextEnabled ? 1 : 0);
            if (nextMibros > 0x3FFFFFFFFFFFFFL || nextMibros < 0L) {
                return -512L;
            }
            long enabledMask = nextEnabled ? 256L : 0L;
            long mibroMask = nextMibros << 10;
            return mibroMask | enabledMask;
        }

        private static long mibrosFromGeneration(long currentGeneration) {
            if (currentGeneration == -512L) {
                throw new IllegalArgumentException();
            }
            return currentGeneration >>> 10;
        }

        private static long mibrosFromNanos(long nanos) {
            long remainder = 0x3FFL & nanos;
            return (nanos >>> 10) + (long)(remainder >= 512L ? 1 : 0);
        }

        protected void startTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.start(gen, taskName, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        protected void startTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.start(gen, taskName);
        }

        protected void startTask(String taskName, String subTaskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.start(gen, taskName, subTaskName);
        }

        protected <T> void startTask(T taskNameObject, StringFunction<? super T> stringFunction) {
            StringFunction<? super T> function = stringFunction;
            this.startTask(taskNameObject, (Function<? super T, String>)function);
        }

        protected <T> void startTask(T taskNameObject, Function<? super T, String> stringFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            String taskName = PerfMarkImpl.deriveTaskValue(taskNameObject, stringFunction);
            markRecorder.start(gen, taskName);
        }

        protected void stopTask() {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long nanoTime = System.nanoTime();
            markRecorder.stopAt(gen, nanoTime);
        }

        protected void stopTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long nanoTime = System.nanoTime();
            markRecorder.stopAt(gen, taskName, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag), nanoTime);
        }

        protected void stopTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long nanoTime = System.nanoTime();
            markRecorder.stopAt(gen, taskName, nanoTime);
        }

        protected void stopTask(String taskName, String subTaskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long nanoTime = System.nanoTime();
            markRecorder.stopAt(gen, taskName, subTaskName, nanoTime);
        }

        protected void event(String eventName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long nanoTime = System.nanoTime();
            markRecorder.eventAt(gen, eventName, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag), nanoTime);
        }

        protected void event(String eventName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long nanoTime = System.nanoTime();
            markRecorder.eventAt(gen, eventName, nanoTime);
        }

        protected void event(String eventName, String subEventName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long nanoTime = System.nanoTime();
            markRecorder.eventAt(gen, eventName, subEventName, nanoTime);
        }

        protected void attachTag(Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.attachTag(gen, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        protected void attachTag(String tagName, String tagValue) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.attachKeyedTag(gen, tagName, tagValue);
        }

        public <T> void attachTag(String tagName, T tagObject, StringFunction<? super T> stringFunction) {
            StringFunction<? super T> function = stringFunction;
            this.attachTag(tagName, tagObject, (Function<? super T, ? extends String>)function);
        }

        protected <T> void attachTag(String tagName, T tagObject, Function<? super T, ? extends String> stringFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            String tagValue = PerfMarkImpl.deriveTagValue(tagName, tagObject, stringFunction);
            markRecorder.attachKeyedTag(gen, tagName, tagValue);
        }

        protected <T> void attachTag(String tagName, T tagObject, ToIntFunction<? super T> intFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long tagValue = PerfMarkImpl.deriveTagValue(tagName, tagObject, intFunction);
            markRecorder.attachKeyedTag(gen, tagName, tagValue);
        }

        protected <T> void attachTag(String tagName, T tagObject, ToLongFunction<? super T> longFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            long tagValue = PerfMarkImpl.deriveTagValue(tagName, tagObject, longFunction);
            markRecorder.attachKeyedTag(gen, tagName, tagValue);
        }

        static <T> String deriveTagValue(String tagName, T tagObject, Function<? super T, ? extends String> stringFunction) {
            try {
                return stringFunction.apply(tagObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTagValueFailure(tagName, tagObject, stringFunction, t);
                return "PerfMarkTagError:" + t.getClass().getName();
            }
        }

        static <T> long deriveTagValue(String tagName, T tagNameObject, ToIntFunction<? super T> intFunction) {
            try {
                return intFunction.applyAsInt(tagNameObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTagValueFailure(tagName, tagNameObject, intFunction, t);
                return Long.MIN_VALUE;
            }
        }

        static <T> long deriveTagValue(String tagName, T tagNameObject, ToLongFunction<? super T> longFunction) {
            try {
                return longFunction.applyAsLong(tagNameObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTagValueFailure(tagName, tagNameObject, longFunction, t);
                return Long.MIN_VALUE;
            }
        }

        static <T> String deriveTaskValue(T taskNameObject, Function<? super T, String> stringFunction) {
            try {
                return stringFunction.apply(taskNameObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTaskNameFailure(taskNameObject, stringFunction, t);
                return "PerfMarkTaskError:" + t.getClass().getName();
            }
        }

        static <T> void handleTagValueFailure(String tagName, T tagObject, Object stringFunction, Throwable cause) {
            if (logger == null) {
                return;
            }
            Logger localLogger = (Logger)logger;
            try {
                if (localLogger.isLoggable(Level.FINE)) {
                    LogRecord lr = new LogRecord(Level.FINE, "PerfMark.attachTag failed: tagName={0}, tagObject={1}, stringFunction={2}");
                    lr.setParameters(new Object[]{tagName, tagObject, stringFunction});
                    lr.setThrown(cause);
                    localLogger.log(lr);
                }
            }
            catch (Throwable t) {
                localLogger.log(Level.FINE, "PerfMark.attachTag failed for {0}: {1}", new Object[]{tagName, t.getClass()});
            }
        }

        static <T> void handleTaskNameFailure(T taskNameObject, Object function, Throwable cause) {
            if (logger == null) {
                return;
            }
            Logger localLogger = (Logger)logger;
            try {
                if (localLogger.isLoggable(Level.FINE)) {
                    LogRecord lr = new LogRecord(Level.FINE, "PerfMark.startTask failed: taskObject={0}, function={1}");
                    lr.setParameters(new Object[]{taskNameObject, function});
                    lr.setThrown(cause);
                    localLogger.log(lr);
                }
            }
            catch (Throwable t) {
                localLogger.log(Level.FINE, "PerfMark.startTask failed for {0}", new Object[]{t.getClass()});
            }
        }

        protected void attachTag(String tagName, long tagValue) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.attachKeyedTag(gen, tagName, tagValue);
        }

        protected void attachTag(String tagName, long tagValue0, long tagValue1) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.attachKeyedTag(gen, tagName, tagValue0, tagValue1);
        }

        protected Tag createTag(String tagName, long tagId) {
            if (!PerfMarkImpl.isEnabled(PerfMarkImpl.getGen())) {
                return NO_TAG;
            }
            return PerfMarkImpl.packTag((String)tagName, (long)tagId);
        }

        protected Link linkOut() {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return NO_LINK;
            }
            long linkId = linkIdAlloc.getAndIncrement();
            markRecorder.link(gen, linkId);
            return PerfMarkImpl.packLink((long)linkId);
        }

        protected void linkIn(Link link) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            markRecorder.link(gen, -PerfMarkImpl.unpackLinkId((Link)link));
        }

        private static long getGen() {
            return generator.getGeneration();
        }

        private static boolean isEnabled(long gen) {
            return (gen >>> 8 & 1L) != 0L;
        }

        static {
            boolean isNoop;
            Class<?> clz;
            NO_TAG = PerfMarkImpl.packTag((String)"", (long)Long.MIN_VALUE);
            NO_LINK = PerfMarkImpl.packLink((long)Long.MIN_VALUE);
            linkIdAlloc = new AtomicLong(1L);
            Generator gen = null;
            Throwable[] problems = new Throwable[4];
            try {
                clz = Class.forName("io.perfmark.java7.SecretGenerator$MethodHandleGenerator");
                gen = clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                problems[0] = t;
            }
            if (gen == null) {
                try {
                    clz = Class.forName("io.perfmark.java9.SecretGenerator$VarHandleGenerator");
                    gen = clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    problems[1] = t;
                }
            }
            if (gen == null) {
                try {
                    clz = Class.forName("io.perfmark.java6.SecretGenerator$VolatileGenerator");
                    gen = clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    problems[2] = t;
                }
            }
            if (gen != null) {
                generator = gen;
                isNoop = false;
            } else {
                generator = new Generator();
                isNoop = true;
            }
            boolean startEnabled = false;
            boolean startEnabledSuccess = false;
            try {
                startEnabled = Boolean.getBoolean("io.perfmark.PerfMark.startEnabled");
                if (startEnabled) {
                    startEnabledSuccess = PerfMarkImpl.setEnabledQuiet(startEnabled, Generator.INIT_NANO_TIME);
                }
            }
            catch (Throwable t) {
                problems[3] = t;
            }
            Logger log = null;
            try {
                if (Boolean.getBoolean("io.perfmark.PerfMark.debug")) {
                    Logger localLogger;
                    log = localLogger = Logger.getLogger(PerfMarkImpl.class.getName());
                    for (Throwable problem : problems) {
                        if (problem == null) continue;
                        localLogger.log(Level.FINE, "Error loading Generator", problem);
                    }
                    localLogger.log(Level.FINE, "Using {0}", new Object[]{generator.getClass().getName()});
                    PerfMarkImpl.logEnabledChange(startEnabled, startEnabledSuccess);
                }
            }
            catch (Throwable localLogger) {
                // empty catch block
            }
            logger = log;
            problems[0] = null;
            problems[1] = null;
            problems[2] = null;
            problems[3] = null;
            MarkRecorder markRecorder0 = null;
            if (!isNoop) {
                Class<?> clz2;
                try {
                    clz2 = Class.forName("io.perfmark.java9.SecretMarkRecorder$VarHandleMarkRecorder");
                    markRecorder0 = clz2.asSubclass(MarkRecorder.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    problems[0] = t;
                }
                if (markRecorder0 == null) {
                    try {
                        clz2 = Class.forName("io.perfmark.java6.SecretMarkRecorder$SynchronizedMarkRecorder");
                        markRecorder0 = clz2.asSubclass(MarkRecorder.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        problems[1] = t;
                    }
                }
            }
            if (markRecorder0 == null) {
                markRecorder0 = new MarkRecorder();
            }
            markRecorder = markRecorder0;
        }
    }
}

