/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.AbstractIndexView;
import io.permazen.core.FieldType;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyRange;
import io.permazen.kv.KeyRanges;
import io.permazen.util.Bounds;
import java.util.Arrays;
import java.util.List;

abstract class AbstractCoreIndex {
    final KVStore kv;
    final AbstractIndexView indexView;

    protected AbstractCoreIndex(KVStore kv, int size, AbstractIndexView indexView) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        Preconditions.checkArgument((indexView != null ? 1 : 0) != 0, (Object)"null indexView");
        this.kv = kv;
        this.indexView = indexView;
        if (this.indexView.fieldTypes.length != size) {
            throw new RuntimeException("internal error: indexView has the wrong size");
        }
    }

    public List<FieldType<?>> getFieldTypes() {
        return Arrays.asList((Object[])this.indexView.fieldTypes.clone());
    }

    public abstract AbstractCoreIndex filter(int var1, KeyFilter var2);

    <T> AbstractCoreIndex filter(int index, FieldType<T> fieldType, Bounds<T> bounds) {
        assert (fieldType == this.indexView.fieldTypes[index]);
        KeyRange range = fieldType.getKeyRange(bounds);
        return !range.isFull() ? this.filter(index, (KeyFilter)new KeyRanges(range)) : this;
    }
}

