/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.FieldType;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyFilterUtil;
import io.permazen.kv.KeyRanges;
import io.permazen.util.ByteUtil;
import java.util.Arrays;

abstract class AbstractIndexView {
    final byte[] prefix;
    final boolean prefixMode;
    final FieldType<?>[] fieldTypes;
    final KeyFilter[] filters;

    protected AbstractIndexView(byte[] prefix, boolean prefixMode, FieldType<?> ... fieldTypes) {
        Preconditions.checkArgument((prefix != null && prefix.length > 0 ? 1 : 0) != 0, (Object)"null/empty prefix");
        Preconditions.checkArgument((fieldTypes != null ? 1 : 0) != 0, (Object)"null fieldTypes");
        this.prefix = prefix;
        this.prefixMode = prefixMode;
        this.fieldTypes = fieldTypes;
        this.filters = new KeyFilter[this.fieldTypes.length];
    }

    protected AbstractIndexView(AbstractIndexView original) {
        this.prefix = original.prefix;
        this.prefixMode = original.prefixMode;
        this.fieldTypes = original.fieldTypes;
        this.filters = (KeyFilter[])original.filters.clone();
    }

    public KeyFilter getFilter(int index) {
        return this.filters[index];
    }

    public boolean hasFilters() {
        for (KeyFilter filter : this.filters) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }

    public AbstractIndexView filter(int index, KeyFilter filter) {
        if (filter == null) {
            throw new IndexOutOfBoundsException("null filter");
        }
        if (filter instanceof KeyRanges && ((KeyRanges)filter).isFull()) {
            return this;
        }
        if (this.filters[index] != null) {
            filter = KeyFilterUtil.intersection((KeyFilter[])new KeyFilter[]{filter, this.filters[index]});
        }
        AbstractIndexView copy = this.copy();
        copy.filters[index] = filter;
        return copy;
    }

    protected abstract AbstractIndexView copy();

    public String toString() {
        return this.getClass().getSimpleName() + "[prefix=" + ByteUtil.toString((byte[])this.prefix) + ",prefixMode=" + this.prefixMode + ",fieldTypes=" + Arrays.asList(this.fieldTypes) + (this.hasFilters() ? ",filters=" + Arrays.asList(this.filters) : "") + "]";
    }
}

