/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.permazen.core.ComplexField;
import io.permazen.core.Field;
import io.permazen.core.ObjId;
import io.permazen.core.ReferenceField;
import io.permazen.core.Schema;
import io.permazen.core.SimpleField;
import io.permazen.core.Transaction;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public abstract class CollectionField<C extends Collection<E>, E>
extends ComplexField<C> {
    public static final String ELEMENT_FIELD_NAME = "element";
    final SimpleField<E> elementField;

    CollectionField(String name, int storageId, Schema schema, TypeToken<C> typeToken, SimpleField<E> elementField) {
        super(name, storageId, schema, typeToken);
        Preconditions.checkArgument((elementField != null ? 1 : 0) != 0, (Object)"null elementField");
        this.elementField = elementField;
        assert (this.elementField.parent == null);
        this.elementField.parent = this;
    }

    public SimpleField<E> getElementField() {
        return this.elementField;
    }

    @Override
    public final List<SimpleField<E>> getSubFields() {
        return Collections.singletonList(this.elementField);
    }

    @Override
    public boolean hasDefaultValue(Transaction tx, ObjId id) {
        return this.getValue(tx, id).isEmpty();
    }

    @Override
    public abstract C getValue(Transaction var1, ObjId var2);

    @Override
    <F> Iterable<F> iterateSubField(Transaction tx, ObjId id, SimpleField<F> subField) {
        if (subField == this.elementField) {
            return this.getValue(tx, id);
        }
        throw new IllegalArgumentException("unknown sub-field");
    }

    @Override
    void unreferenceRemovedTypes(Transaction tx, ObjId id, ReferenceField subField, SortedSet<Integer> removedStorageIds) {
        assert (subField == this.elementField);
        Iterator i = ((Collection)this.getValueInternal(tx, id)).iterator();
        while (i.hasNext()) {
            ObjId ref = (ObjId)i.next();
            if (ref == null || !removedStorageIds.contains(ref.getStorageId())) continue;
            i.remove();
        }
    }

    @Override
    boolean isUpgradeCompatible(Field<?> field) {
        if (field.getClass() != this.getClass()) {
            return false;
        }
        CollectionField that = (CollectionField)field;
        return this.elementField.isUpgradeCompatible(that.elementField);
    }
}

