/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.permazen.core.ComplexSubFieldStorageInfo;
import io.permazen.core.Field;
import io.permazen.core.ObjId;
import io.permazen.core.ReferenceField;
import io.permazen.core.Schema;
import io.permazen.core.SimpleField;
import io.permazen.core.StorageInfo;
import io.permazen.core.Transaction;
import io.permazen.kv.KVPair;
import io.permazen.kv.KeyRange;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteUtil;
import io.permazen.util.ByteWriter;
import io.permazen.util.CloseableIterator;
import io.permazen.util.UnsignedIntEncoder;
import java.util.List;
import java.util.SortedSet;

public abstract class ComplexField<T>
extends Field<T> {
    private final int storageIdLength;

    ComplexField(String name, int storageId, Schema schema, TypeToken<T> typeToken) {
        super(name, storageId, schema, typeToken);
        this.storageIdLength = UnsignedIntEncoder.encodeLength((int)storageId);
    }

    public abstract List<? extends SimpleField<?>> getSubFields();

    abstract T getValueInternal(Transaction var1, ObjId var2);

    abstract T getValueReadOnlyCopy(Transaction var1, ObjId var2);

    abstract <F> Iterable<F> iterateSubField(Transaction var1, ObjId var2, SimpleField<F> var3);

    @Override
    final StorageInfo toStorageInfo() {
        return null;
    }

    abstract ComplexSubFieldStorageInfo<?, ?> toStorageInfo(SimpleField<?> var1);

    void deleteContent(Transaction tx, ObjId id) {
        byte[] minKey = this.buildKey(id);
        byte[] maxKey = ByteUtil.getKeyAfterPrefix((byte[])minKey);
        this.deleteContent(tx, minKey, maxKey);
    }

    void deleteContent(Transaction tx, byte[] minKey, byte[] maxKey) {
        tx.kvt.removeRange(minKey, maxKey);
    }

    void addIndexEntry(Transaction tx, ObjId id, SimpleField<?> subField, byte[] contentKey, byte[] contentValue) {
        tx.kvt.put(this.buildIndexEntry(id, subField, contentKey, contentValue), ByteUtil.EMPTY);
    }

    void removeIndexEntry(Transaction tx, ObjId id, SimpleField<?> subField, byte[] contentKey, byte[] contentValue) {
        tx.kvt.remove(this.buildIndexEntry(id, subField, contentKey, contentValue));
    }

    private byte[] buildIndexEntry(ObjId id, SimpleField<?> subField, byte[] contentKey, byte[] contentValue) {
        ByteReader contentKeyReader = new ByteReader(contentKey);
        contentKeyReader.skip(8 + this.storageIdLength);
        ByteWriter writer = new ByteWriter();
        UnsignedIntEncoder.write((ByteWriter)writer, (int)subField.storageId);
        this.buildIndexEntry(id, subField, contentKeyReader, contentValue, writer);
        return writer.getBytes();
    }

    abstract void buildIndexEntry(ObjId var1, SimpleField<?> var2, ByteReader var3, byte[] var4, ByteWriter var5);

    void addIndexEntries(Transaction tx, ObjId id, SimpleField<?> subField) {
        Preconditions.checkArgument((boolean)subField.indexed, (Object)"not indexed");
        byte[] prefix = this.buildKey(id);
        byte[] prefixEnd = ByteUtil.getKeyAfterPrefix((byte[])prefix);
        try (CloseableIterator i = tx.kvt.getRange(prefix, prefixEnd);){
            while (i.hasNext()) {
                KVPair pair = (KVPair)i.next();
                assert (KeyRange.forPrefix((byte[])prefix).contains(pair.getKey()));
                this.addIndexEntry(tx, id, subField, pair.getKey(), pair.getValue());
            }
        }
    }

    void removeIndexEntries(Transaction tx, ObjId id) {
        this.getSubFields().stream().filter(subField -> subField.indexed).forEach(subField -> this.removeIndexEntries(tx, id, (SimpleField<?>)subField));
    }

    void removeIndexEntries(Transaction tx, ObjId id, SimpleField<?> subField) {
        byte[] prefix = this.buildKey(id);
        this.removeIndexEntries(tx, id, subField, prefix, ByteUtil.getKeyAfterPrefix((byte[])prefix));
    }

    void removeIndexEntries(Transaction tx, ObjId id, SimpleField<?> subField, byte[] minKey, byte[] maxKey) {
        Preconditions.checkArgument((boolean)subField.indexed, (Object)"not indexed");
        try (CloseableIterator i = tx.kvt.getRange(minKey, maxKey);){
            while (i.hasNext()) {
                KVPair pair = (KVPair)i.next();
                assert (new KeyRange(minKey, maxKey).contains(pair.getKey()));
                this.removeIndexEntry(tx, id, subField, pair.getKey(), pair.getValue());
            }
        }
    }

    abstract void unreferenceRemovedTypes(Transaction var1, ObjId var2, ReferenceField var3, SortedSet<Integer> var4);
}

