/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.permazen.core.CompositeIndexStorageInfo;
import io.permazen.core.ObjType;
import io.permazen.core.Schema;
import io.permazen.core.SchemaItem;
import io.permazen.core.SimpleField;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeIndex
extends SchemaItem {
    final ObjType objType;
    final List<SimpleField<?>> fields;

    CompositeIndex(String name, int storageId, Schema schema, ObjType objType, Iterable<? extends SimpleField<?>> fields) {
        super(name, storageId, schema);
        Preconditions.checkArgument((objType != null ? 1 : 0) != 0, (Object)"null objType");
        Preconditions.checkArgument((fields != null ? 1 : 0) != 0, (Object)"null fields");
        this.objType = objType;
        this.fields = Collections.unmodifiableList(Lists.newArrayList(fields));
    }

    public ObjType getObjType() {
        return this.objType;
    }

    public List<SimpleField<?>> getFields() {
        return this.fields;
    }

    @Override
    public String toString() {
        return "composite index `" + this.name + "' on fields " + this.fields.stream().map(field -> field.name).collect(Collectors.toList());
    }

    @Override
    CompositeIndexStorageInfo toStorageInfo() {
        return new CompositeIndexStorageInfo(this);
    }
}

